/*****************************************************************************

        AioAdd.h
        Author: Laurent de Soras, 2011

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*Tab=3***********************************************************************/



#if ! defined (conc_AioAdd_HEADER_INCLUDED)
#define	conc_AioAdd_HEADER_INCLUDED

#if defined (_MSC_VER)
	#pragma once
	#pragma warning (4 : 4250)
#endif



/*\\\ INCLUDE FILES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



namespace conc
{



template <class T>
class AioAdd
{

/*\\\ PUBLIC \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:

	explicit inline
	               AioAdd (T operand);
	virtual        ~AioAdd () = default;

	inline T       operator () (T old_val) const noexcept;



/*\\\ PROTECTED \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

protected:



/*\\\ PRIVATE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

	T              _operand;



/*\\\ FORBIDDEN MEMBER FUNCTIONS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

	               AioAdd ()                                   = delete;
	               AioAdd (const AioAdd <T> &other)            = delete;
	               AioAdd (const AioAdd <T> &&other)           = delete;
	AioAdd <T> &   operator = (const AioAdd <T> &other)        = delete;
	AioAdd <T> &   operator = (const AioAdd <T> &&other)       = delete;
	bool           operator == (const AioAdd <T> &other) const = delete;
	bool           operator != (const AioAdd <T> &other) const = delete;

};	// class AioAdd



}	// namespace conc



#include "conc/AioAdd.hpp"



#endif	// conc_AioAdd_HEADER_INCLUDED



/*\\\ EOF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
