2020-12-03 Triage Log

A fairly mixed week with regressions and improvements mainly washing each other out with the exception of the very large improvement to [incremental compilation](https://github.com/rust-lang/rust/issues/74967) with huge gains in a large portion of the perf test suite.

Triage done by **@rylev**.
Revision range: [25a691003cf6676259ee7d4bed05b43cb6283cea..c7cff213e937c1bb301be807ce04fcf6092b9163](https://perf.rust-lang.org/?start=25a691003cf6676259ee7d4bed05b43cb6283cea&end=c7cff213e937c1bb301be807ce04fcf6092b9163&absolute=false&stat=instructions%3Au)

2 Regressions, 2 Improvement, 2 Mixed
0 of them in rollups

#### Regressions

[#79284](https://github.com/rust-lang/rust/issues/79284)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=6a889570e46c03d7b156ec08f3f4cb4d145924a3&end=fd6b5376b723e22e3d98542e2e693d2717700900&stat=instructions:u) (up to 31.5% on `full` builds of `match-stress-enum-check`)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=6a889570e46c03d7b156ec08f3f4cb4d145924a3&end=fd6b5376b723e22e3d98542e2e693d2717700900&stat=instructions:u) (up to -1.2% on `full` builds of `issue-58319-check`)
- The very large regression outweighs the moderate improvement.
- It's hard to tell what the issue is currently since the change involved moving large chunks of code to different files making it hard to tell what the actual changes are.

[#78725](https://github.com/rust-lang/rust/issues/78725)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=29c4358c189fbb3bd3fd7ac3d7a95fac7b97814c&end=c4926d01ada661d4fbffb0e5b1708ae5463d47b3&stat=instructions:u) (up to 2.6% on `full` builds of `ctfe-stress-4-check`)
- This change was a removal in an unneeded call to `upvar_tys`, and is not immeadiately obvious to the author where the regression is coming from.

#### Improvements

[#74967](https://github.com/rust-lang/rust/issues/74967)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=b2dd82929b5b956972446d9720ceabdee171d405&end=4cbda829c00af2c3ac362c979fa97ea90be0be7d&stat=instructions:u) (up to -37.5% on `incr-unchanged` builds of `helloworld-check`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=b2dd82929b5b956972446d9720ceabdee171d405&end=4cbda829c00af2c3ac362c979fa97ea90be0be7d&stat=instructions:u) (up to 1.5% on `incr-unchanged` builds of `clap-rs-check`)
- A huge win for incremental compilation almost across the board with only a small regression in one test. 🎉

[#79523](https://github.com/rust-lang/rust/issues/79523)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=88b81970ba7a989a728b32039dd075dc206f1360&end=b776d1c3e3db8befabb123ebb1e46c3531eaed46&stat=instructions:u) (up to -2.3% on `full` builds of `unicode_normalization-check`)
- Small fix on exhaustiveness checking for `isize/usize` range patterns.
- Hard to tell where the perf gain comes from though it might be that part of the implementation was simplified enough to be inlined. 
- Unfortunately these perf gains are completely canceled out by the regression in [#79284](https://github.com/rust-lang/rust/issues/79284)

#### Mixed

[#79318](https://github.com/rust-lang/rust/issues/79318)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=361543d776d832b42f022f5b3aa1ab77263bc4a9&end=c9228570668803e3e6402770d55f23a12c9ae686&stat=instructions:u) (up to -4.7% on `incr-unchanged` builds of `deeply-nested-async-check`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=361543d776d832b42f022f5b3aa1ab77263bc4a9&end=c9228570668803e3e6402770d55f23a12c9ae686&stat=instructions:u) (up to 4.6% on `incr-full` builds of `externs-check`)
- A ~4% regression occured in the `extern` stress test which is likely to exercise this change quite a bit.

[#79547](https://github.com/rust-lang/rust/issues/79547)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=d37afad0cc87bf709ad10c85319296ac53030f03&end=a094ff9590b83c8f94d898f92c2964a5803ded06&stat=instructions:u) (up to -1.9% on `incr-unchanged` builds of `html5ever-check`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=d37afad0cc87bf709ad10c85319296ac53030f03&end=a094ff9590b83c8f94d898f92c2964a5803ded06&stat=instructions:u) (up to 1.7% on `full` builds of `deeply-nested-debug`)
- This change makes small arguments (those equal to or less than `2 * size_of::<usize>()`) passed to functions in registers instead of by reference. This is unlikely to have too much effect on the compiler due to the compiler normally pasing large arguments to functions but it might help other workloads.

#### Nags requiring follow up

- Three pull requests require a follow up on their regressions: [#79318](https://github.com/rust-lang/rust/issues/79318), [#79284](https://github.com/rust-lang/rust/issues/79284), and [#78725](https://github.com/rust-lang/rust/issues/78725).
- [One of last week's nags](https://github.com/rust-lang/rust/pull/79167#issuecomment-733207145) has yet to be fully resolved.

