/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.imex;

import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.entity.api.LinkFactory;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.ui.graph.imex.IOHelper;
import org.openide.util.Exceptions;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import yguard.A.H.B.A.H;
import yguard.A.H.B.B.Z;

public class MaltegoLinkIO {
    public MaltegoLink read(Node node) throws Z {
        String type = IOHelper.getRequiredAttribute(node, "type");
        String id = IOHelper.getOptionalAttribute(node, "id", null);
        String reversed = IOHelper.getOptionalAttribute(node, "reversed", null);
        LinkID guid = id != null ? LinkID.parse((String)id) : null;
        MaltegoLink link = guid != null ? LinkFactory.getDefault().createInstance(type, guid, false) : LinkFactory.getDefault().createInstance(type, false);
        Element properties = IOHelper.findElement(node, "Properties");
        if (properties != null) {
            this.attachProperties(link, properties);
        }
        if (reversed != null && reversed.toLowerCase().equals("true")) {
            link.setReversed(Boolean.valueOf(true));
        }
        node.setTextContent(null);
        return link;
    }

    private void attachProperties(MaltegoLink link, Node properties) throws Z {
        NodeList children = properties.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !"Property".equals(child.getLocalName())) continue;
            String name = IOHelper.getRequiredAttribute(child, "name");
            if (!link.getProperties().contains(name)) {
                this.attachProperty(link, child);
            }
            String valueString = IOHelper.getValue(child);
            PropertyDescriptor pd = link.getProperties().get(name);
            try {
                Object value = Converter.convertFrom((String)valueString, (Class)pd.getType());
                link.setValue(pd, value);
                continue;
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                TypeDescriptor type = TypeRegistry.getDefault().getType(pd.getType());
                if (type == null) continue;
                link.setValue(pd, type.getDefaultValue());
            }
        }
    }

    private void attachProperty(MaltegoLink link, Node property) throws Z {
        String name = IOHelper.getRequiredAttribute(property, "name");
        String type = IOHelper.getRequiredAttribute(property, "type");
        TypeDescriptor td = TypeRegistry.getDefault().getType(type);
        if (td == null) {
            throw new Z("The data type " + type + " is not known.");
        }
        String displayName = IOHelper.getStringAttribute(property, "displayName");
        PropertyDescriptor pd = new PropertyDescriptor(td.getType(), name, displayName);
        pd.setHidden(IOHelper.getBooleanAttribute(property, "hidden", false));
        pd.setNullable(IOHelper.getBooleanAttribute(property, "nullable", true));
        pd.setReadonly(IOHelper.getBooleanAttribute(property, "readonly", false));
        link.getProperties().add(pd);
    }

    public void write(H writer, MaltegoLink link) {
        writer.A("mtg", "MaltegoLink", "http://maltego.paterva.com/xml/mtgx");
        writer.B("type", link.getTypeName());
        writer.B("id", ((LinkID)link.getID()).toString());
        this.writeProperties(writer, link);
        writer.C();
    }

    private void writeProperties(H writer, MaltegoLink link) {
        writer.A("mtg", "Properties", "http://maltego.paterva.com/xml/mtgx");
        MaltegoLinkSpec spec = (MaltegoLinkSpec)LinkRegistry.getDefault().get(link.getTypeName());
        for (PropertyDescriptor pd : link.getProperties()) {
            DisplayDescriptor dd;
            boolean shouldWrite = true;
            if (link.getValue(pd) == null && spec != null && (dd = spec.getProperties().get(pd.getName())) != null && dd.getDefaultValue() == null) {
                shouldWrite = false;
            }
            if (!shouldWrite) continue;
            if (("maltego.link.style".equals(pd.getName()) || "maltego.link.thickness".equals(pd.getName())) && Integer.valueOf(-1).equals(link.getValue(pd))) {
                shouldWrite = false;
            }
            if (!shouldWrite) continue;
            IOHelper.writeProperty(writer, (MaltegoPart<? extends Guid>)link, pd);
        }
        writer.C();
    }
}

