/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.repository;

import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformFilter;
import com.paterva.maltego.transform.descriptor.TransformRepository;
import com.paterva.maltego.transform.gen.TransformSourceRegistry;
import com.paterva.maltego.transform.gen.TransformSourceTransformSettings;
import com.paterva.maltego.util.Args;
import java.util.Set;
import java.util.stream.Collectors;

public class TransformSourceTransformRepository
extends TransformRepository {
    public Set<TransformDefinition> getAll() {
        return TransformSourceRegistry.getInstance().getAllTransforms();
    }

    public TransformDefinition get(String uniqueName) {
        Args.notNullOrBlank((String)uniqueName, (String)"uniqueName");
        Set<TransformDefinition> transforms = this.find(transform -> uniqueName.equals(transform.getName()));
        return transforms.size() > 0 ? transforms.iterator().next() : null;
    }

    public Set<TransformDefinition> find(TransformFilter filter) {
        Args.notNull((Object)filter, (String)"filter");
        return this.getAll().stream().filter(arg_0 -> ((TransformFilter)filter).matches(arg_0)).collect(Collectors.toSet());
    }

    public void updateSettings(TransformDefinition transform) {
        Args.notNull((Object)transform, (String)"transform");
        TransformSourceTransformSettings.updateSettings((TransformDefinition)transform);
    }

    public boolean remove(String uniqueName) {
        throw this.createUnsupportedException();
    }

    public void put(TransformDescriptor descriptor) {
        throw this.createUnsupportedException();
    }

    private RuntimeException createUnsupportedException() {
        return new UnsupportedOperationException("Not supported for Transform Sources.");
    }
}

