/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.welcome.update.wizard;

import com.paterva.maltego.util.ui.dialog.ProgressController;
import com.paterva.maltego.util.ui.dialog.WizardUtilities;
import com.paterva.maltego.welcome.update.wizard.UpdateDetectController;
import com.paterva.maltego.welcome.update.wizard.UpdateInstallController;
import com.paterva.maltego.welcome.update.wizard.UpdateWizardConstants;
import java.awt.Component;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;

final class UpdateWizardIterator<Data>
implements WizardDescriptor.Iterator<Data> {
    private WizardDescriptor _wd;
    private UpdateDetectController _panelDetect;
    private UpdateInstallController _panelInstall;
    private ArrayList<WizardDescriptor.Panel> _panelsVisible;
    private int _index = 0;

    UpdateWizardIterator() {
    }

    public void initialize(WizardDescriptor wd) {
        this._wd = wd;
        this.createPanels();
    }

    private void createPanels() {
        this._panelDetect = new UpdateDetectController();
        this._panelInstall = new UpdateInstallController();
        WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[]{this._panelDetect, this._panelInstall};
        WizardUtilities.updatePanels((WizardDescriptor.Panel[])panels);
        this._panelDetect.addNavigationListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                UpdateWizardIterator.this.updateVisiblePanels();
            }
        });
        this.updateVisiblePanels();
    }

    public WizardDescriptor.Panel<Data> current() {
        return this._panelsVisible.get(this._index);
    }

    public String name() {
        return "Update Maltego";
    }

    public boolean hasNext() {
        Boolean foundUpdates = (Boolean)this._wd.getProperty(UpdateWizardConstants.PROP_UPDATES_FOUND);
        boolean hasNext = this._index < this._panelsVisible.size() - 1 && (foundUpdates == null || foundUpdates != false);
        return hasNext;
    }

    public boolean hasPrevious() {
        boolean canBack;
        WizardDescriptor.Panel currentPanel = this._panelsVisible.get(this._index);
        boolean bl = canBack = this._index > 0;
        if (canBack && currentPanel instanceof ProgressController) {
            ProgressController controller = (ProgressController)currentPanel;
            canBack &= controller.canBack();
        }
        return canBack;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this._index;
        this.updateVisiblePanels();
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this._index;
        this.updateVisiblePanels();
    }

    private void updateVisiblePanels() {
        Boolean foundUpdates = (Boolean)this._wd.getProperty(UpdateWizardConstants.PROP_UPDATES_FOUND);
        this._wd.putProperty("WizardPanel_helpDisplayed", (Object)Boolean.FALSE);
        this._panelsVisible = new ArrayList();
        this._panelsVisible.add((WizardDescriptor.Panel)this._panelDetect);
        if (foundUpdates == null || foundUpdates.booleanValue()) {
            this._panelsVisible.add((WizardDescriptor.Panel)this._panelInstall);
        }
        this.updateContentPane(foundUpdates);
    }

    private void updateContentPane(Boolean foundUpdates) {
        String[] steps = this.getContentData(foundUpdates);
        for (int i = 0; i < this._panelsVisible.size(); ++i) {
            WizardDescriptor.Panel panel = this._panelsVisible.get(i);
            Component c = panel.getComponent();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    private String[] getContentData(Boolean foundUpdates) {
        ArrayList<String> steps = new ArrayList<String>();
        for (int i = 0; i < this._panelsVisible.size(); ++i) {
            WizardDescriptor.Panel panel = this._panelsVisible.get(i);
            steps.add(panel.getComponent().getName());
            if (foundUpdates != null && !foundUpdates.booleanValue()) break;
            if (foundUpdates != null || i < this._index || panel != this._panelDetect) continue;
            steps.add("...");
            break;
        }
        return steps.toArray(new String[steps.size()]);
    }

    public void addChangeListener(ChangeListener cl) {
    }

    public void removeChangeListener(ChangeListener cl) {
    }
}

