/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.form.adapters;

import com.paterva.maltego.typing.editing.form.adapters.AbstractControlAdapter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class TextBoxAdapter
extends AbstractControlAdapter<JTextField, String> {
    TextBoxAdapter() {
    }

    @Override
    public JTextField create() {
        JTextField field = this.createTextComponent();
        field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextBoxAdapter.this.fireEditingFinished(e);
            }
        });
        field.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                TextBoxAdapter.this.fireChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TextBoxAdapter.this.fireChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TextBoxAdapter.this.fireChange();
            }
        });
        return field;
    }

    protected JTextField createTextComponent() {
        return new JTextField(25);
    }

    @Override
    public void setValue(Component component, Object value) {
        super.setValue(component, value != null ? value.toString() : null);
    }

    @Override
    protected void set(JTextField component, String value) {
        if (value == null) {
            component.setText("");
        } else {
            component.setText(value);
        }
    }

    @Override
    protected String get(JTextField component) {
        return component.getText();
    }

    @Override
    protected boolean empty(JTextField component) {
        return "".equals(component.getText());
    }
}

