/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.view;

import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.automation.MachineRepository;
import com.paterva.maltego.automation.view.MachineActions;
import com.paterva.maltego.util.ui.outline.NodePropertySupport;
import java.awt.Image;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.Action;
import org.openide.actions.DeleteAction;
import org.openide.explorer.view.CheckableNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class MachineDescriptorNode
extends AbstractNode
implements CheckableNode {
    public MachineDescriptorNode(MachineDescriptor item) {
        this(item, new InstanceContent());
    }

    protected MachineDescriptorNode(MachineDescriptor item, InstanceContent content) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        content.add((Object)item);
        content.add((Object)this);
    }

    public String getDisplayName() {
        return this.getDescriptor().getDisplayName();
    }

    public String getShortDescription() {
        return this.getDescriptor().getDescription();
    }

    private MachineDescriptor getDescriptor() {
        return (MachineDescriptor)this.getLookup().lookup(MachineDescriptor.class);
    }

    public Action getPreferredAction() {
        List actions = Utilities.actionsForPath((String)"Maltego/ContextActions/MachineDescriptor");
        if (actions != null && actions.size() > 0) {
            return (Action)actions.get(0);
        }
        return null;
    }

    public boolean isCheckable() {
        return true;
    }

    public boolean isCheckEnabled() {
        return true;
    }

    public Boolean isSelected() {
        return ((MachineDescriptor)this.getLookup().lookup(MachineDescriptor.class)).isEnabled();
    }

    public void setSelected(Boolean value) {
        Boolean oldValue = this.isSelected();
        if (!oldValue.equals(value)) {
            MachineDescriptor machineDescriptor = (MachineDescriptor)this.getLookup().lookup(MachineDescriptor.class);
            machineDescriptor.setEnabled(value);
            try {
                MachineRepository.getDefault().update(machineDescriptor);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.firePropertyChange("status", oldValue, value);
            this.onEnabledChange(value);
        }
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put((Node.Property)new Status((Node)this));
        set.put((Node.Property)new Author((Node)this));
        set.put((Node.Property)new Description((Node)this));
        set.put((Node.Property)new Readonly((Node)this));
        sheet.put(set);
        return sheet;
    }

    protected void onEnabledChange(boolean enabled) {
    }

    public Image getIcon(int type) {
        boolean enabled = this.isSelected();
        if (enabled) {
            return ImageUtilities.loadImage((String)"com/paterva/maltego/automation/resources/Robot.png");
        }
        return ImageUtilities.loadImage((String)"com/paterva/maltego/automation/resources/Robot_disabled.png");
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() throws IOException {
        MachineActions.delete((MachineDescriptor)this.getLookup().lookup(MachineDescriptor.class));
        super.destroy();
    }

    public Action[] getActions(boolean context) {
        return new SystemAction[]{SystemAction.get(DeleteAction.class)};
    }

    static class Readonly
    extends NodePropertySupport.ReadOnly<Boolean> {
        public Readonly(Node node) {
            super(node, "readonly", Boolean.class, "Read-only", "Indicates whether this machine can be edited.");
        }

        public Boolean getValue() throws IllegalAccessException, InvocationTargetException {
            return ((MachineDescriptor)this.getLookup().lookup(MachineDescriptor.class)).isReadOnly();
        }
    }

    static class Status
    extends NodePropertySupport.ReadOnly<String> {
        public Status(Node node) {
            super(node, "status", String.class, "Status", "Indicates whether this machine is active.");
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            if (((MachineDescriptor)this.getLookup().lookup(MachineDescriptor.class)).isEnabled()) {
                return "Enabled";
            }
            return "Disabled";
        }
    }

    private static class Author
    extends NodePropertySupport.ReadOnly<String> {
        public Author(Node node) {
            super(node, "author", String.class, "Author", "Author who created the machine");
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            String desc = ((MachineDescriptor)this.getLookup().lookup(MachineDescriptor.class)).getAuthor();
            if (desc == null) {
                return "<none>";
            }
            return desc;
        }
    }

    private static class Description
    extends NodePropertySupport.ReadOnly<String> {
        public Description(Node node) {
            super(node, "description", String.class, "Description", "Description of this machine");
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            String desc = ((MachineDescriptor)this.getLookup().lookup(MachineDescriptor.class)).getDescription();
            if (desc == null) {
                return "<none>";
            }
            return desc;
        }
    }
}

