/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.customization.ui.imex;

import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.archive.mtz.MaltegoArchiveWriter;
import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigExporter;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.view.customization.api.Viewlet;
import com.paterva.maltego.view.customization.ui.ViewletRegistry;
import com.paterva.maltego.view.customization.ui.imex.SelectableView;
import com.paterva.maltego.view.customization.ui.imex.SelectableViewlet;
import com.paterva.maltego.view.customization.ui.imex.Util;
import com.paterva.maltego.view.customization.ui.imex.ViewletAttributesEntry;
import com.paterva.maltego.view.customization.ui.imex.ViewletAttributesWrapper;
import com.paterva.maltego.view.customization.ui.imex.ViewletConfig;
import com.paterva.maltego.view.customization.ui.imex.ViewletEntry;
import com.paterva.maltego.view.customization.ui.imex.ViewletWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ViewletExporter
extends ConfigExporter {
    public Config getCurrentConfig() {
        Map<String, Set<Viewlet>> viewletsPerView = ViewletRegistry.getDefault().getAll();
        if (!viewletsPerView.isEmpty()) {
            return new ViewletConfig(Util.createSelectables(viewletsPerView));
        }
        return null;
    }

    public int saveConfig(MaltegoArchiveWriter writer, Config config) throws IOException {
        ViewletConfig viewletConfig = (ViewletConfig)config;
        ArrayList<String> names = new ArrayList<String>();
        for (SelectableView view : viewletConfig.getSelectedViews()) {
            String viewID = view.getViewID();
            for (SelectableViewlet selectable : view) {
                if (!selectable.isSelected()) continue;
                Viewlet viewlet = selectable.getViewlet();
                String fileName = this.getFileName(viewlet, names);
                writer.write((Entry)new ViewletEntry(new ViewletWrapper(viewID, fileName, viewlet)));
                writer.write((Entry)new ViewletAttributesEntry(new ViewletAttributesWrapper(viewID, fileName, viewlet)));
            }
        }
        return names.size();
    }

    private String getFileName(Viewlet viewlet, List<String> names) {
        String name = viewlet.getName();
        String fileName = FileUtilities.replaceIllegalChars((String)name);
        fileName = StringUtilities.createUniqueString(names, (String)fileName);
        names.add(fileName);
        return fileName;
    }
}

