/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*************************************************************************
 *
 *  The Contents of this file are made available subject to the terms of
 *  the BSD license.
 *
 *  Copyright 2000, 2010 Oracle and/or its affiliates.
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. Neither the name of Sun Microsystems, Inc. nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 *  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 *  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 *  TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 *  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *************************************************************************/

#ifndef INCLUDED_EXAMPLES_DATABASE_DRIVERSKELETON_SCONNECTION_HXX
#define INCLUDED_EXAMPLES_DATABASE_DRIVERSKELETON_SCONNECTION_HXX

#include <com/sun/star/sdbc/SQLWarning.hpp>
#include <com/sun/star/beans/PropertyValue.hpp>
#include "OSubComponent.hxx"
#include "OTypeInfo.hxx"
#include <com/sun/star/lang/DisposedException.hpp>
#include <com/sun/star/lang/XServiceInfo.hpp>
#include <com/sun/star/lang/XUnoTunnel.hpp>
#include <com/sun/star/sdbc/XWarningsSupplier.hpp>
#include <com/sun/star/sdbc/XConnection.hpp>
#include <cppuhelper/compbase3.hxx>
#include <cppuhelper/weakref.hxx>

#include <map>

namespace connectivity
{
    namespace skeleton
    {

        typedef ::cppu::WeakComponentImplHelper3<   ::com::sun::star::sdbc::XConnection,
                                                ::com::sun::star::sdbc::XWarningsSupplier,
                                                ::com::sun::star::lang::XServiceInfo
                                            > OMetaConnection_BASE;

        class OStatement_Base;
        class SkeletonDriver;
        class ODatabaseMetaData;

        typedef OMetaConnection_BASE                OConnection_BASE; // implements basics and text encoding
        typedef ::std::vector< ::connectivity::OTypeInfo>   TTypeInfoVector;
        typedef std::vector< ::com::sun::star::uno::WeakReferenceHelper > OWeakRefArray;

        class OConnection : public OBase_Mutex,
                            public OConnection_BASE,
                            public connectivity::skeleton::OSubComponent<OConnection, OConnection_BASE>
        {
            friend class connectivity::skeleton::OSubComponent<OConnection, OConnection_BASE>;

        protected:

            rtl_TextEncoding                        m_nTextEncoding; // the encoding which is used for all text conversions

            // Data attributes

            TTypeInfoVector                         m_aTypeInfo;    //  vector containing an entry
                                                                    //  for each row returned by
                                                                    //  DatabaseMetaData.getTypeInfo.
            ::com::sun::star::uno::WeakReference< ::com::sun::star::sdbc::XDatabaseMetaData > m_xMetaData;

            OWeakRefArray                           m_aStatements;  //  vector containing a list
                                                        //  of all the Statement objects
                                                        //  for this Connection

            ::com::sun::star::sdbc::SQLWarning      m_aLastWarning; //      Last SQLWarning generated by
                                                        //  an operation
            ::rtl::OUString                         m_aURL;         //  URL of connection
            ::rtl::OUString                         m_sUser;        // the user name
            SkeletonDriver*                         m_pDriver;      //  Pointer to the owning
                                                                    //  driver object

            sal_Bool                                m_bClosed;
            sal_Bool                                m_bUseCatalog;  // should we use the catalog on filebased databases
            sal_Bool                                m_bUseOldDateFormat;


            void                    buildTypeInfo();

        public:
            virtual void construct( const ::rtl::OUString& url,const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& info);

            OConnection(SkeletonDriver* _pDriver);
            virtual ~OConnection();

            void closeAllStatements ();

            // OComponentHelper
            virtual void SAL_CALL disposing();
            // XInterface
            virtual void SAL_CALL release() throw();

            // XServiceInfo
            DECLARE_SERVICE_INFO();
            // XConnection
            virtual ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XStatement > SAL_CALL createStatement(  );
            virtual ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XPreparedStatement > SAL_CALL prepareStatement( const ::rtl::OUString& sql );
            virtual ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XPreparedStatement > SAL_CALL prepareCall( const ::rtl::OUString& sql );
            virtual ::rtl::OUString SAL_CALL nativeSQL( const ::rtl::OUString& sql );
            virtual void SAL_CALL setAutoCommit( sal_Bool autoCommit );
            virtual sal_Bool SAL_CALL getAutoCommit(  );
            virtual void SAL_CALL commit(  );
            virtual void SAL_CALL rollback(  );
            virtual sal_Bool SAL_CALL isClosed(  );
            virtual ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XDatabaseMetaData > SAL_CALL getMetaData(  );
            virtual void SAL_CALL setReadOnly( sal_Bool readOnly );
            virtual sal_Bool SAL_CALL isReadOnly(  );
            virtual void SAL_CALL setCatalog( const ::rtl::OUString& catalog );
            virtual ::rtl::OUString SAL_CALL getCatalog(  );
            virtual void SAL_CALL setTransactionIsolation( sal_Int32 level );
            virtual sal_Int32 SAL_CALL getTransactionIsolation(  );
            virtual ::com::sun::star::uno::Reference< ::com::sun::star::container::XNameAccess > SAL_CALL getTypeMap(  );
            virtual void SAL_CALL setTypeMap( const ::com::sun::star::uno::Reference< ::com::sun::star::container::XNameAccess >& typeMap );
            // XCloseable
            virtual void SAL_CALL close(  );
            // XWarningsSupplier
            virtual ::com::sun::star::uno::Any SAL_CALL getWarnings(  );
            virtual void SAL_CALL clearWarnings(  );


            // should we use the catalog on filebased databases
            inline sal_Bool         isCatalogUsed()     const { return m_bUseCatalog; }
            inline ::rtl::OUString  getUserName()       const { return m_sUser; }
            inline SkeletonDriver*  getDriver()         const { return m_pDriver;}
            inline rtl_TextEncoding getTextEncoding()   const { return m_nTextEncoding; }
        };
    }
}

#endif // INCLUDED_EXAMPLES_DATABASE_DRIVERSKELETON_SCONNECTION_HXX

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
