/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#include <types.h>

namespace gb
{
    using namespace types;

    class LinkTarget;

    class Executable : public IsCleanable, public HasDependencies, public IsLinking, public DeliversHeaders, public HasCompileSettings, public Target
    {
        public:
            Executable(String name);

        private:
            /// private helper function for the constructor
            void Executable_impl(LinkTarget library_linktarget);
            /// platformdependant additional setup for constructor (used on Windows only)
            void Executable_platform(LinkTarget library_linktarget);
            /// helper function to wrap LinkTargets functions (this is more or less pimpl ...)
            void forward_to_linktarget(Function f);

            static const List<String> TARGETTYPEFLAGS;
    };
}
/* vim: set filetype=cpp : */
