struct cpuinfo_mock_file filesystem[] = {
#if CPUINFO_ARCH_ARM64
	{
		.path = "/proc/cpuinfo",
		.size = 327,
		.content =
			"Processor\t: AArch64 Processor rev 4 (aarch64)\n"
			"processor\t: 0\n"
			"processor\t: 1\n"
			"processor\t: 2\n"
			"processor\t: 3\n"
			"processor\t: 4\n"
			"processor\t: 5\n"
			"Features\t: fp asimd evtstrm aes pmull sha1 sha2 crc32 \n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 8\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xd03\n"
			"CPU revision\t: 4\n"
			"\n"
			"Hardware\t: Qualcomm Technologies, Inc MSM8956\n",
	},
#elif CPUINFO_ARCH_ARM
	{
		.path = "/proc/cpuinfo",
		.size = 588,
		.content =
			"WARNING: linker: /data/local/tmp/cpuinfo-dump: unused DT entry: type 0x6ffffffe arg 0x52c\r\n"
			"WARNING: linker: /data/local/tmp/cpuinfo-dump: unused DT entry: type 0x6fffffff arg 0x1\r\n"
			"Processor\t: AArch64 Processor rev 4 (aarch64)\r\n"
			"processor\t: 0\r\n"
			"processor\t: 1\r\n"
			"processor\t: 2\r\n"
			"processor\t: 3\r\n"
			"processor\t: 4\r\n"
			"processor\t: 5\r\n"
			"Features\t: fp asimd evtstrm aes pmull sha1 sha2 crc32 wp half thumb fastmult vfp edsp neon vfpv3 tlsi vfpv4 idiva idivt \r\n"
			"CPU implementer\t: 0x41\r\n"
			"CPU architecture: 8\r\n"
			"CPU variant\t: 0x0\r\n"
			"CPU part\t: 0xd03\r\n"
			"CPU revision\t: 4\r\n"
			"\r\n"
			"Hardware\t: Qualcomm Technologies, Inc MSM8956\r\n",
	},
#endif
	{
		.path = "/system/build.prop",
		.size = 9921,
		.content =
			"\n"
			"# begin build properties\n"
			"# autogenerated by buildinfo.sh\n"
			"ro.build.id=LMY47V\n"
			"ro.build.display.id=LMY47V\n"
			"ro.build.version.incremental=V8.0.7.0.LHOCNDG\n"
			"ro.build.version.sdk=22\n"
			"ro.build.version.codename=REL\n"
			"ro.build.version.all_codenames=REL\n"
			"ro.build.version.release=5.1.1\n"
			"ro.build.version.security_patch=2016-11-01\n"
			"ro.build.version.base_os=\n"
			"ro.build.date=Fri Nov 25 12:39:19 CST 2016\n"
			"ro.build.date.utc=1480048759\n"
			"ro.build.type=user\n"
			"ro.build.user=builder\n"
			"ro.build.host=c3-miui-ota-bd72.bj\n"
			"ro.build.tags=release-keys\n"
			"ro.build.flavor=kenzo-user\n"
			"ro.product.model=Redmi Note 3\n"
			"ro.product.brand=Xiaomi\n"
			"ro.product.name=kenzo\n"
			"ro.product.device=kenzo\n"
			"ro.product.board=msm8952\n"
			"# ro.product.cpu.abi and ro.product.cpu.abi2 are obsolete,\n"
			"# use ro.product.cpu.abilist instead.\n"
			"ro.product.cpu.abi=arm64-v8a\n"
			"ro.product.cpu.abilist=arm64-v8a,armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist32=armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist64=arm64-v8a\n"
			"ro.product.locale.language=zh\n"
			"ro.product.locale.region=CN\n"
			"ro.wifi.channels=\n"
			"ro.board.platform=msm8952\n"
			"# ro.build.product is obsolete; use ro.product.device\n"
			"ro.build.product=kenzo\n"
			"# Do not try to parse description, fingerprint, or thumbprint\n"
			"ro.build.description=kenzo-user 5.1.1 LMY47V V8.0.7.0.LHOCNDG release-keys\n"
			"ro.build.fingerprint=Xiaomi/kenzo/kenzo:5.1.1/LMY47V/V8.0.7.0.LHOCNDG:user/release-keys\n"
			"ro.build.characteristics=nosdcard\n"
			"ro.build.version.internal=MI_C0907_00_A\n"
			"ro.build.version.external=MI_M866\n"
			"ro.build.display.hardware=\n"
			"ro.build.network.type=\n"
			"ro.build.project=\n"
			"ro.build.device.ninur=64687\n"
			"ro.build.version.bsp=0.5.3_0907\n"
			"ro.build.hardware.version=M850_D2-2\n"
			"persist.service.logd.enable=\n"
			"# end build properties\n"
			"#\n"
			"# from device/qcom/kenzo/system.prop\n"
			"#\n"
			"#\n"
			"# system.prop for msm8952\n"
			"#\n"
			"\n"
			"rild.libpath=/vendor/lib64/libril-qc-qmi-1.so\n"
			"rild.libargs=-d /dev/smd0\n"
			"persist.rild.nitz_plmn=\n"
			"persist.rild.nitz_long_ons_0=\n"
			"persist.rild.nitz_long_ons_1=\n"
			"persist.rild.nitz_long_ons_2=\n"
			"persist.rild.nitz_long_ons_3=\n"
			"persist.rild.nitz_short_ons_0=\n"
			"persist.rild.nitz_short_ons_1=\n"
			"persist.rild.nitz_short_ons_2=\n"
			"persist.rild.nitz_short_ons_3=\n"
			"ril.subscription.types=RUIM\n"
			"DEVICE_PROVISIONED=1\n"
			"# Start in cdma mode\n"
			"ro.telephony.default_network=22\n"
			"persist.sys.ssr.enable_ramdumps=1\n"
			"persist.sys.ssr.restart_level=modem\n"
			"persist.dbg.volte_avail_ovr=1\n"
			"persist.dbg.vt_avail_ovr=1\n"
			"persist.radio.redir_party_num=0\n"
			"persist.radio.start_ota_daemon=1\n"
			"persist.radio.force_on_dc=true\n"
			"persist.radio.NO_STAPA=1\n"
			"persist.radio.cs_srv_type=1\n"
			"\n"
			"persist.sys.fp.goodix=0\n"
			"\n"
			"debug.sf.hw=0\n"
			"debug.egl.hw=0\n"
			"persist.hwc.mdpcomp.enable=true\n"
			"debug.mdpcomp.logs=0\n"
			"dalvik.vm.heapsize=36m\n"
			"dev.pm.dyn_samplingrate=1\n"
			"persist.demo.hdmirotationlock=false\n"
			"debug.enable.sglscale=1\n"
			"persist.hwc.downscale_threshold=1.15\n"
			"\n"
			"#ro.hdmi.enable=true\n"
			"#tunnel.decode=true\n"
			"#tunnel.audiovideo.decode=true\n"
			"#lpa.decode=false\n"
			"#lpa.use-stagefright=true\n"
			"#persist.speaker.prot.enable=false\n"
			"qcom.hw.aac.encoder=true\n"
			"\n"
			"#\n"
			"# system props for the cne module\n"
			"#\n"
			"persist.cne.feature=1\n"
			"# enable nsrm --huanbin add\n"
			"persist.dpm.feature=7\n"
			"persist.dpm.nsrm.bkg.evt=16251\n"
			"persist.sys.dpmd.nsrm=3\n"
			"\n"
			"#system props for the MM modules\n"
			"media.stagefright.enable-player=true\n"
			"media.stagefright.enable-http=true\n"
			"media.stagefright.enable-aac=true\n"
			"media.stagefright.enable-qcp=true\n"
			"media.stagefright.enable-fma2dp=true\n"
			"media.stagefright.enable-scan=true\n"
			"media.msm8956hw=0\n"
			"mm.enable.smoothstreaming=true\n"
			"mmp.enable.3g2=true\n"
			"media.aac_51_output_enabled=true\n"
			"\n"
			"#codecs:(PARSER_)AAC AC3 AMR_NB AMR_WB ASF AVI DTS FLV 3GP 3G2 MKV MP2PS MP2TS MP3 OGG QCP WAV FLAC AIFF APE\n"
			"#donghaizhou W_And388913 W_And390083 MKV/MP3 use google_parser\n"
			"#mm.enable.qcom_parser=1048575\n"
			"mm.enable.qcom_parser=1039359\n"
			"av.debug.disable.pers.cache=true\n"
			"# Additional buffers shared between Camera and Video\n"
			"vidc.enc.dcvs.extra-buff-count=2\n"
			"\n"
			"# Default to AwesomePlayer\n"
			"media.stagefright.use-awesome=false\n"
			"#Audio voice concurrency related flags\n"
			"voice.playback.conc.disabled=true\n"
			"voice.record.conc.disabled=false\n"
			"voice.voip.conc.disabled=true\n"
			"#Decides the audio fallback path during voice call, deep-buffer and fast are the two allowed fallback paths now.\n"
			"voice.conc.fallbackpath=deep-buffer\n"
			"\n"
			"#\n"
			"# system props for the data modules\n"
			"#\n"
			"ro.use_data_netmgrd=true\n"
			"persist.data.netmgrd.qos.enable=true\n"
			"persist.data.mode=concurrent\n"
			"\n"
			"#system props for time-services\n"
			"persist.timed.enable=true\n"
			"\n"
			"#\n"
			"# system prop for opengles version\n"
			"#\n"
			"# 196608 is decimal for 0x30000 to report major/minor versions as 3/0\n"
			"# 196609 is decimal for 0x30001 to report major/minor versions as 3/1\n"
			"ro.opengles.version=196609\n"
			"\n"
			"# System property for cabl\n"
			"ro.qualcomm.cabl=0\n"
			"\n"
			"#\n"
			"# System props for telephony\n"
			"# System prop to turn on CdmaLTEPhone always\n"
			"telephony.lteOnCdmaDevice=1\n"
			"\n"
			"#\n"
			"# System props for bluetooh\n"
			"# System prop to turn on hfp client\n"
			"bluetooth.hfp.client=1\n"
			"\n"
			"#Simulate sdcard on /data/media\n"
			"#\n"
			"persist.fuse_sdcard=true\n"
			"\n"
			"#\n"
			"#snapdragon value add features\n"
			"#\n"
			"ro.qc.sdk.audio.ssr=false\n"
			"##fluencetype can be \"fluence\" or \"fluencepro\" or \"none\"\n"
			"ro.qc.sdk.audio.fluencetype=fluence\n"
			"persist.audio.fluence.voicecall=true\n"
			"persist.audio.fluence.voicerec=true\n"
			"persist.audio.fluence.speaker=true\n"
			"# xuke @ 20151201\n"
			"persist.audio.fluence.audiorec=false\n"
			"# xuke @ 20151106\tTo support fluence mode by single MIC.\n"
			"persist.audio.fluence.spk.mono=true\n"
			"#Set for msm8952\n"
			"tunnel.audio.encode = false\n"
			"#Buffer size in kbytes for compress offload playback\n"
			"audio.offload.buffer.size.kb=64\n"
			"#Minimum duration for offload playback in secs\n"
			"audio.offload.min.duration.secs=30\n"
			"#Enable offload audio video playback by default\n"
			"av.offload.enable=true\n"
			"\n"
			"#Enable PCM offload by default\n"
			"audio.offload.pcm.16bit.enable=false\n"
			"audio.offload.pcm.24bit.enable=false\n"
			"#enable voice path for PCM VoIP by default\n"
			"use.voice.path.for.pcm.voip=true\n"
			"\n"
			"#System property for FM transmitter\n"
			"ro.fm.transmitter=false\n"
			"# Dirac\t\tBegin\n"
			"#enable dirac effect for speaker\n"
			"persist.audio.dirac.speaker=true\n"
			"# Dirac\t\tEnd\n"
			"#enable dsp gapless mode by default\n"
			"audio.offload.gapless.enabled=true\n"
			"\n"
			"#multi offload\n"
			"audio.offload.multiple.enabled=false\n"
			"\n"
			"#enable pbe effects\n"
			"audio.safx.pbe.enabled=true\n"
			"#property for AudioSphere Post processing\n"
			"audio.pp.asphere.enabled=false\n"
			"\n"
			"#Set composition for USB\n"
			"# persist.sys.usb.config=diag,serial_smd,rmnet_ipa,adb\n"
			"\n"
			"#Set read only default composition for USB\n"
			"ro.sys.usb.default.config=diag,serial_smd,rmnet_ipa,adb\n"
			"\n"
			"#property to enable user to access Google WFD settings\n"
			"persist.debug.wfd.enable=1\n"
			"#property to enable VDS WFD solution\n"
			"persist.hwc.enable_vds=1\n"
			"\n"
			"#selects CoreSight configuration to enable\n"
			"persist.debug.coresight.config=stm-events\n"
			"\n"
			"#ad\n"
			"ro.qcom.ad=1\n"
			"ro.qcom.ad.calib.data=/system/etc/calib.cfg\n"
			"ro.qcom.ad.sensortype=2\n"
			"\n"
			"#property for vendor specific library\n"
			"ro.vendor.at_library=libqti-at.so\n"
			"ro.vendor.gt_library=libqti-gt.so\n"
			"\n"
			"#property to enable narrow search range for video encoding\n"
			"vidc.enc.narrow.searchrange=1\n"
			"\n"
			"#property to enable fingerprint\n"
			"persist.qfp=false\n"
			"\n"
			"#min/max cpu in core control\n"
			"ro.core_ctl_min_cpu=2\n"
			"ro.core_ctl_max_cpu=4\n"
			"\n"
			"#property to enable DS2 dap\n"
			"audio.dolby.ds2.enabled=true\n"
			"\n"
			"#HWUI properties\n"
			"ro.hwui.text_large_cache_height=2048\n"
			"\n"
			"#Enable B service adj transition by default\n"
			"ro.sys.fw.bservice_enable=true\n"
			"ro.sys.fw.bservice_limit=5\n"
			"ro.sys.fw.bservice_age=5000\n"
			"\n"
			"# Enable Delay Service Restart\n"
			"ro.am.reschedule_service=true\n"
			"\n"
			"#Trim properties\n"
			"ro.sys.fw.use_trim_settings=true\n"
			"ro.sys.fw.empty_app_percent=50\n"
			"ro.sys.fw.trim_empty_percent=100\n"
			"ro.sys.fw.trim_cache_percent=100\n"
			"ro.sys.fw.trim_enable_memory=2147483648\n"
			"\n"
			"#Optimal dex2oat threads for faster app installation\n"
			"ro.sys.fw.dex2oat_thread_count=4\n"
			"\n"
			"# set cutoff voltage to 3200mV\n"
			"ro.cutoff_voltage_mv=3200\n"
			"\n"
			"#set the debug configuration for 8956/76\n"
			"persist.debug.8976.config=true\n"
			"\n"
			"#force HAL1 for below packages\n"
			"camera.hal1.packagelist=com.skype.raider,com.google.android.talk\n"
			"\n"
			"#properties for limiting preview size in camera\n"
			"camera.display.umax=1920x1080\n"
			"camera.display.lmax=1280x720\n"
			"\n"
			"#low power mode for camera\n"
			"camera.lowpower.record.enable=1\n"
			"\n"
			"#enable game colocation feature\n"
			"sched.colocate.enable=1\n"
			"\n"
			"ro.build.device.ninur=64687\n"
			"\n"
			"# button jack mode & switch\t\txuke @ 20151208\tImport patch for headset button.\n"
			"persist.sys.button_jack_profile=volume\n"
			"persist.sys.button_jack_switch=0\n"
			"\n"
			"#\n"
			"# ADDITIONAL_BUILD_PROPERTIES\n"
			"#\n"
			"ro.miui.version.code_time=1469635200\n"
			"ro.miui.ui.version.code=6\n"
			"ro.miui.ui.version.name=V8\n"
			"persist.sys.mcd_config_file=/system/etc/mcd_default.conf\n"
			"persist.sys.whetstone.level=2\n"
			"ro.ss.version=3.4.106\n"
			"ro.ss.nohidden=true\n"
			"dalvik.vm.heapgrowthlimit=128m\n"
			"dalvik.vm.heapminfree=4m\n"
			"dalvik.vm.heapstartsize=16m\n"
			"ro.com.android.dateformat=MM-dd-yyyy\n"
			"ro.carrier=unknown\n"
			"ro.vendor.extension_library=libqti-perfd-client.so\n"
			"persist.radio.sib16_support=1\n"
			"persist.radio.custom_ecc=1\n"
			"ro.frp.pst=/dev/block/bootdevice/by-name/config\n"
			"dalvik.vm.heapsize=256m\n"
			"dalvik.vm.heaptargetutilization=0.75\n"
			"dalvik.vm.heapmaxfree=8m\n"
			"audio.offload.disable=1\n"
			"persist.sys.dalvik.vm.lib.2=libart.so\n"
			"dalvik.vm.isa.arm64.features=div,needfix_835769\n"
			"dalvik.vm.isa.arm.features=div\n"
			"net.bt.name=Android\n"
			"dalvik.vm.stack-trace-file=/data/anr/traces.txt\n"
			"ro.miui.has_real_blur=1\n"
			"ro.miui.has_handy_mode_sf=1\n"
			"persist.gps.qc_nlp_in_use=1\n"
			"persist.loc.nlp_name=com.qualcomm.location\n"
			"ro.gps.agps_provider=1\n"
			"ro.pip.gated=0\n"
			"persist.radio.calls.on.ims=0\n"
			"persist.radio.jbims=0\n"
			"persist.radio.csvt.enabled=false\n"
			"persist.radio.rat_on=combine\n"
			"persist.radio.mt_sms_ack=20\n"
			"ro.config.sms_received_sound=FadeIn.ogg\n"
			"ro.config.sms_delivered_sound=MessageComplete.ogg\n"
			"ro.com.android.mobiledata=false\n"
			"ro.product.manufacturer=Xiaomi\n"
			"ro.config.elder-ringtone=Angel.mp3\n"
			"keyguard.no_require_sim=true\n"
			"ro.com.android.dataroaming=false\n"
			"persist.sys.mitalk.enable=true\n"
			"ro.config.ringtone=Ring_Synth_04.ogg\n"
			"ro.config.notification_sound=pixiedust.ogg\n"
			"ro.config.alarm_alert=Alarm_Classic.ogg\n"
			"ro.product.cuptsm=XIAOMI|ESE|02|01\n"
			"persist.power.useautobrightadj=true\n"
			"persist.radio.apm_sim_not_pwdn=1\n"
			"qemu.hw.mainkeys=1\n"
			"ro.com.google.clientidbase=android-xiaomi\n"
			"\n"
			"\n"
			"import /system/vendor/default.prop\n"
			"\n"
			"import /system/vendor/vendor.prop\n"
			"\n"
			"import /system/vendor/power.prop\n"
			"\n"
			"\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/bus_split",
		.size = 3,
		.content = "1\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/default_pwrlevel",
		.size = 3,
		.content = "4\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/dev",
		.size = 7,
		.content = "241:0\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/available_frequencies",
		.size = 91,
		.content = "133333333 200000000 266666667 300000000 366670000 432000000 480000000 550000000 600000000\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/available_governors",
		.size = 110,
		.content = "spdm_bw_hyp bw_hwmon bw_vbif gpubw_mon msm-adreno-tz cpufreq userspace powersave performance simple_ondemand\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/cur_freq",
		.size = 11,
		.content = "266666667\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/governor",
		.size = 15,
		.content = "msm-adreno-tz\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/max_freq",
		.size = 11,
		.content = "600000000\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/min_freq",
		.size = 11,
		.content = "266666667\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/polling_interval",
		.size = 4,
		.content = "10\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/target_freq",
		.size = 11,
		.content = "266666667\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/trans_stat",
		.size = 423,
		.content =
			"   From  :   To\r\n"
			"         :600000000480000000432000000300000000266666667   time(ms)\r\n"
			" 600000000:       0       0       0       0       0         0\r\n"
			" 480000000:       0       0       1       0       2     42840\r\n"
			" 432000000:       0       0       0       1       2      1540\r\n"
			" 300000000:       0       0       2       0       3      1090\r\n"
			"*266666667:       0       3       0       4       0    380980\r\n"
			"Total transition : 18\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/ft_fast_hang_detect",
		.size = 3,
		.content = "1\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/ft_hang_intr_status",
		.size = 3,
		.content = "1\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/ft_long_ib_detect",
		.size = 3,
		.content = "1\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/ft_pagefault_policy",
		.size = 5,
		.content = "0x0\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/ft_policy",
		.size = 6,
		.content = "0xC2\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/gpu_available_frequencies",
		.size = 52,
		.content = "600000000 480000000 432000000 300000000 266666667 \r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/gpubusy",
		.size = 17,
		.content = " 261084 1011474\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/gpuclk",
		.size = 11,
		.content = "266666667\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/idle_timer",
		.size = 4,
		.content = "80\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/lm",
		.size = 3,
		.content = "0\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/max_gpuclk",
		.size = 11,
		.content = "600000000\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/max_pwrlevel",
		.size = 3,
		.content = "0\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/min_pwrlevel",
		.size = 3,
		.content = "4\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/num_pwrlevels",
		.size = 3,
		.content = "5\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/pmqos_active_latency",
		.size = 5,
		.content = "401\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/popp",
		.size = 3,
		.content = "0\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/reset_count",
		.size = 5,
		.content = "169\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/sptp_pc",
		.size = 3,
		.content = "1\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/thermal_pwrlevel",
		.size = 3,
		.content = "0\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/wake_nice",
		.size = 4,
		.content = "-7\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/wake_timeout",
		.size = 5,
		.content = "100\r\n",
	},
	{
		.path = "/sys/devices/soc0/accessory_chip",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/soc0/build_id",
		.size = 25,
		.content = "8976A-EAASANAZA-40000000\n",
	},
	{
		.path = "/sys/devices/soc0/foundry_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/soc0/hw_platform",
		.size = 4,
		.content = "MTP\n",
	},
	{
		.path = "/sys/devices/soc0/image_crm_version",
		.size = 5,
		.content =
			"REL\n"
			"\n",
	},
	{
		.path = "/sys/devices/soc0/image_variant",
		.size = 12,
		.content =
			"kenzo-user\n"
			"\n",
	},
	{
		.path = "/sys/devices/soc0/image_version",
		.size = 28,
		.content =
			"10:LMY47V:V8.0.7.0.LHOCNDG\n"
			"\n",
	},
	{
		.path = "/sys/devices/soc0/machine",
		.size = 11,
		.content = "Snapdragon\n",
	},
	{
		.path = "/sys/devices/soc0/platform_subtype",
		.size = 8,
		.content = "Unknown\n",
	},
	{
		.path = "/sys/devices/soc0/platform_subtype_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/soc0/platform_version",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/soc0/pmic_die_revision",
		.size = 7,
		.content = "131072\n",
	},
	{
		.path = "/sys/devices/soc0/pmic_model",
		.size = 6,
		.content = "65552\n",
	},
	{
		.path = "/sys/devices/soc0/raw_id",
		.size = 5,
		.content = "2480\n",
	},
	{
		.path = "/sys/devices/soc0/raw_version",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/soc0/revision",
		.size = 4,
		.content = "1.1\n",
	},
	{
		.path = "/sys/devices/soc0/select_image",
		.size = 3,
		.content = "10\n",
	},
	{
		.path = "/sys/devices/soc0/soc_id",
		.size = 4,
		.content = "266\n",
	},
	{
		.path = "/sys/devices/soc0/vendor",
		.size = 9,
		.content = "Qualcomm\n",
	},
	{
		.path = "/sys/devices/system/cpu/kernel_max",
		.size = 2,
		.content = "7\n",
	},
	{
		.path = "/sys/devices/system/cpu/modalias",
		.size = 66,
		.content = "cpu:type:aarch64:feature:,0000,0001,0002,0003,0004,0005,0006,0007\n",
	},
	{
		.path = "/sys/devices/system/cpu/offline",
		.size = 1,
		.content = "\n",
	},
	{
		.path = "/sys/devices/system/cpu/online",
		.size = 4,
		.content = "0-5\n",
	},
	{
		.path = "/sys/devices/system/cpu/possible",
		.size = 4,
		.content = "0-5\n",
	},
	{
		.path = "/sys/devices/system/cpu/present",
		.size = 4,
		.content = "0-5\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_driver",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_governor_ro",
		.size = 5,
		.content = "menu\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/core_ctl/busy_up_thres",
		.size = 9,
		.content = "0 0 0 0 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/core_ctl/busy_down_thres",
		.size = 9,
		.content = "0 0 0 0 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/core_ctl/global_state",
		.size = 527,
		.content =
			"CPU0\n"
			"\tCPU: 0\n"
			"\tOnline: 1\n"
			"\tRejected: 0\n"
			"\tFirst CPU: 0\n"
			"\tBusy%: 3\n"
			"\tIs busy: 1\n"
			"\tNr running: 0\n"
			"\tAvail CPUs: 4\n"
			"\tNeed CPUs: 4\n"
			"CPU1\n"
			"\tCPU: 1\n"
			"\tOnline: 1\n"
			"\tRejected: 0\n"
			"\tFirst CPU: 0\n"
			"\tBusy%: 0\n"
			"\tIs busy: 1\n"
			"CPU2\n"
			"\tCPU: 2\n"
			"\tOnline: 1\n"
			"\tRejected: 0\n"
			"\tFirst CPU: 0\n"
			"\tBusy%: 10\n"
			"\tIs busy: 1\n"
			"CPU3\n"
			"\tCPU: 3\n"
			"\tOnline: 1\n"
			"\tRejected: 0\n"
			"\tFirst CPU: 0\n"
			"\tBusy%: 2\n"
			"\tIs busy: 1\n"
			"CPU4\n"
			"\tCPU: 4\n"
			"\tOnline: 1\n"
			"\tRejected: 0\n"
			"\tFirst CPU: 4\n"
			"\tBusy%: 0\n"
			"\tIs busy: 0\n"
			"\tNr running: 0\n"
			"\tAvail CPUs: 2\n"
			"\tNeed CPUs: 0\n"
			"CPU5\n"
			"\tCPU: 5\n"
			"\tOnline: 1\n"
			"\tRejected: 0\n"
			"\tFirst CPU: 4\n"
			"\tBusy%: 0\n"
			"\tIs busy: 0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/core_ctl/is_big_cluster",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/core_ctl/max_cpus",
		.size = 2,
		.content = "4\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/core_ctl/min_cpus",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/core_ctl/need_cpus",
		.size = 2,
		.content = "4\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/core_ctl/not_preferred",
		.size = 36,
		.content =
			"\tCPU:0 0\n"
			"\tCPU:1 0\n"
			"\tCPU:2 0\n"
			"\tCPU:3 0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/core_ctl/offline_delay_ms",
		.size = 4,
		.content = "100\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/core_ctl/task_thres",
		.size = 11,
		.content = "4294967295\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpuidle/driver/name",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1401600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "400000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_frequencies",
		.size = 62,
		.content = "400000 691200 806400 1017600 1190400 1305600 1382400 1401600 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "interactive ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "691200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/time_in_state",
		.size = 94,
		.content =
			"400000 0\n"
			"691200 34849\n"
			"806400 234\n"
			"1017600 415\n"
			"1190400 176\n"
			"1305600 2200\n"
			"1382400 91\n"
			"1401600 4725\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/total_trans",
		.size = 5,
		.content = "1183\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings",
		.size = 3,
		.content = "01\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings_list",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpuidle/driver/name",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1401600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "400000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_frequencies",
		.size = 62,
		.content = "400000 691200 806400 1017600 1190400 1305600 1382400 1401600 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "interactive ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "691200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/time_in_state",
		.size = 94,
		.content =
			"400000 0\n"
			"691200 35077\n"
			"806400 234\n"
			"1017600 415\n"
			"1190400 176\n"
			"1305600 2200\n"
			"1382400 91\n"
			"1401600 4725\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/total_trans",
		.size = 5,
		.content = "1183\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings",
		.size = 3,
		.content = "02\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings_list",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpuidle/driver/name",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1401600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "400000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_frequencies",
		.size = 62,
		.content = "400000 691200 806400 1017600 1190400 1305600 1382400 1401600 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "interactive ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "691200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/time_in_state",
		.size = 94,
		.content =
			"400000 0\n"
			"691200 35312\n"
			"806400 234\n"
			"1017600 415\n"
			"1190400 176\n"
			"1305600 2200\n"
			"1382400 91\n"
			"1401600 4725\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/total_trans",
		.size = 5,
		.content = "1183\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_id",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings",
		.size = 3,
		.content = "04\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings_list",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpuidle/driver/name",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1401600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "400000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_available_frequencies",
		.size = 62,
		.content = "400000 691200 806400 1017600 1190400 1305600 1382400 1401600 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "interactive ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "691200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/time_in_state",
		.size = 94,
		.content =
			"400000 0\n"
			"691200 35557\n"
			"806400 234\n"
			"1017600 415\n"
			"1190400 176\n"
			"1305600 2200\n"
			"1382400 91\n"
			"1401600 4725\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/total_trans",
		.size = 5,
		.content = "1183\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_id",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/thread_siblings",
		.size = 3,
		.content = "08\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/thread_siblings_list",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/core_ctl/busy_up_thres",
		.size = 7,
		.content = "68 68 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/core_ctl/busy_down_thres",
		.size = 7,
		.content = "40 40 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/core_ctl/global_state",
		.size = 526,
		.content =
			"CPU0\n"
			"\tCPU: 0\n"
			"\tOnline: 1\n"
			"\tRejected: 0\n"
			"\tFirst CPU: 0\n"
			"\tBusy%: 1\n"
			"\tIs busy: 1\n"
			"\tNr running: 0\n"
			"\tAvail CPUs: 4\n"
			"\tNeed CPUs: 4\n"
			"CPU1\n"
			"\tCPU: 1\n"
			"\tOnline: 1\n"
			"\tRejected: 0\n"
			"\tFirst CPU: 0\n"
			"\tBusy%: 0\n"
			"\tIs busy: 1\n"
			"CPU2\n"
			"\tCPU: 2\n"
			"\tOnline: 1\n"
			"\tRejected: 0\n"
			"\tFirst CPU: 0\n"
			"\tBusy%: 7\n"
			"\tIs busy: 1\n"
			"CPU3\n"
			"\tCPU: 3\n"
			"\tOnline: 1\n"
			"\tRejected: 0\n"
			"\tFirst CPU: 0\n"
			"\tBusy%: 0\n"
			"\tIs busy: 1\n"
			"CPU4\n"
			"\tCPU: 4\n"
			"\tOnline: 1\n"
			"\tRejected: 0\n"
			"\tFirst CPU: 4\n"
			"\tBusy%: 0\n"
			"\tIs busy: 0\n"
			"\tNr running: 0\n"
			"\tAvail CPUs: 2\n"
			"\tNeed CPUs: 0\n"
			"CPU5\n"
			"\tCPU: 5\n"
			"\tOnline: 1\n"
			"\tRejected: 0\n"
			"\tFirst CPU: 4\n"
			"\tBusy%: 0\n"
			"\tIs busy: 0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/core_ctl/is_big_cluster",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/core_ctl/max_cpus",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/core_ctl/min_cpus",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/core_ctl/need_cpus",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/core_ctl/not_preferred",
		.size = 18,
		.content =
			"\tCPU:4 0\n"
			"\tCPU:5 0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/core_ctl/offline_delay_ms",
		.size = 4,
		.content = "100\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/core_ctl/task_thres",
		.size = 11,
		.content = "4294967295\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpuidle/driver/name",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/affected_cpus",
		.size = 4,
		.content = "4 5\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1804800\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "400000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/related_cpus",
		.size = 4,
		.content = "4 5\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/scaling_available_frequencies",
		.size = 101,
		.content = "400000 883200 940800 998400 1056000 1113600 1190400 1248000 1305600 1382400 1612800 1747200 1804800 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "interactive ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "883200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "1804800\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "883200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/stats/time_in_state",
		.size = 142,
		.content =
			"400000 0\n"
			"883200 39978\n"
			"940800 27\n"
			"998400 15\n"
			"1056000 11\n"
			"1113600 77\n"
			"1190400 10\n"
			"1248000 16\n"
			"1305600 0\n"
			"1382400 530\n"
			"1612800 68\n"
			"1747200 0\n"
			"1804800 2914\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/stats/total_trans",
		.size = 4,
		.content = "739\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/topology/core_siblings",
		.size = 3,
		.content = "30\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/topology/core_siblings_list",
		.size = 4,
		.content = "4-5\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/topology/physical_package_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/topology/thread_siblings",
		.size = 3,
		.content = "10\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/topology/thread_siblings_list",
		.size = 2,
		.content = "4\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpuidle/driver/name",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/affected_cpus",
		.size = 4,
		.content = "4 5\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1804800\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "400000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/related_cpus",
		.size = 4,
		.content = "4 5\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/scaling_available_frequencies",
		.size = 101,
		.content = "400000 883200 940800 998400 1056000 1113600 1190400 1248000 1305600 1382400 1612800 1747200 1804800 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "interactive ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "883200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "1804800\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "883200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/stats/time_in_state",
		.size = 142,
		.content =
			"400000 0\n"
			"883200 40217\n"
			"940800 27\n"
			"998400 15\n"
			"1056000 11\n"
			"1113600 77\n"
			"1190400 10\n"
			"1248000 16\n"
			"1305600 0\n"
			"1382400 530\n"
			"1612800 68\n"
			"1747200 0\n"
			"1804800 2914\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/stats/total_trans",
		.size = 4,
		.content = "739\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/topology/core_id",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/topology/core_siblings",
		.size = 3,
		.content = "30\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/topology/core_siblings_list",
		.size = 4,
		.content = "4-5\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/topology/physical_package_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/topology/thread_siblings",
		.size = 3,
		.content = "20\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/topology/thread_siblings_list",
		.size = 2,
		.content = "5\n",
	},
	{ NULL },
};
#ifdef __ANDROID__
struct cpuinfo_mock_property properties[] = {
	{
		.key = "DEVICE_PROVISIONED",
		.value = "1",
	},
	{
		.key = "audio.dolby.ds2.enabled",
		.value = "true",
	},
	{
		.key = "audio.offload.buffer.size.kb",
		.value = "64",
	},
	{
		.key = "audio.offload.disable",
		.value = "1",
	},
	{
		.key = "audio.offload.gapless.enabled",
		.value = "true",
	},
	{
		.key = "audio.offload.min.duration.secs",
		.value = "30",
	},
	{
		.key = "audio.offload.multiple.enabled",
		.value = "false",
	},
	{
		.key = "audio.offload.pcm.16bit.enable",
		.value = "false",
	},
	{
		.key = "audio.offload.pcm.24bit.enable",
		.value = "false",
	},
	{
		.key = "audio.pp.asphere.enabled",
		.value = "false",
	},
	{
		.key = "audio.safx.pbe.enabled",
		.value = "true",
	},
	{
		.key = "av.debug.disable.pers.cache",
		.value = "true",
	},
	{
		.key = "av.offload.enable",
		.value = "true",
	},
	{
		.key = "bluetooth.hfp.client",
		.value = "1",
	},
	{
		.key = "camera.display.lmax",
		.value = "1280x720",
	},
	{
		.key = "camera.display.umax",
		.value = "1920x1080",
	},
	{
		.key = "camera.hal1.packagelist",
		.value = "com.skype.raider,com.google.android.talk",
	},
	{
		.key = "camera.lowpower.record.enable",
		.value = "1",
	},
	{
		.key = "dalvik.vm.dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.dex2oat-Xmx",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.heapgrowthlimit",
		.value = "128m",
	},
	{
		.key = "dalvik.vm.heapmaxfree",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heapminfree",
		.value = "4m",
	},
	{
		.key = "dalvik.vm.heapsize",
		.value = "256m",
	},
	{
		.key = "dalvik.vm.heapstartsize",
		.value = "16m",
	},
	{
		.key = "dalvik.vm.heaptargetutilization",
		.value = "0.75",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xmx",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.isa.arm.features",
		.value = "div",
	},
	{
		.key = "dalvik.vm.isa.arm64.features",
		.value = "div,needfix_835769",
	},
	{
		.key = "dalvik.vm.stack-trace-file",
		.value = "/data/anr/traces.txt",
	},
	{
		.key = "debug.egl.hw",
		.value = "0",
	},
	{
		.key = "debug.enable.sglscale",
		.value = "1",
	},
	{
		.key = "debug.force_rtl",
		.value = "0",
	},
	{
		.key = "debug.mdpcomp.logs",
		.value = "0",
	},
	{
		.key = "debug.sf.hw",
		.value = "0",
	},
	{
		.key = "dev.bootcomplete",
		.value = "1",
	},
	{
		.key = "dev.pm.dyn_samplingrate",
		.value = "1",
	},
	{
		.key = "dhcp.wlan0.dns1",
		.value = "208.67.222.222",
	},
	{
		.key = "dhcp.wlan0.dns2",
		.value = "208.67.220.220",
	},
	{
		.key = "dhcp.wlan0.dns3",
		.value = "",
	},
	{
		.key = "dhcp.wlan0.dns4",
		.value = "",
	},
	{
		.key = "dhcp.wlan0.domain",
		.value = "tfbnw.net",
	},
	{
		.key = "dhcp.wlan0.gateway",
		.value = "172.22.192.1",
	},
	{
		.key = "dhcp.wlan0.ipaddress",
		.value = "172.22.220.111",
	},
	{
		.key = "dhcp.wlan0.leasetime",
		.value = "1800",
	},
	{
		.key = "dhcp.wlan0.mask",
		.value = "255.255.224.0",
	},
	{
		.key = "dhcp.wlan0.mtu",
		.value = "",
	},
	{
		.key = "dhcp.wlan0.pid",
		.value = "6541",
	},
	{
		.key = "dhcp.wlan0.reason",
		.value = "BOUND",
	},
	{
		.key = "dhcp.wlan0.result",
		.value = "ok",
	},
	{
		.key = "dhcp.wlan0.server",
		.value = "192.168.137.185",
	},
	{
		.key = "dhcp.wlan0.vendorInfo",
		.value = "",
	},
	{
		.key = "gsm.current.phone-type",
		.value = "1,1",
	},
	{
		.key = "gsm.network.type",
		.value = "Unknown,Unknown",
	},
	{
		.key = "gsm.operator.alpha",
		.value = "",
	},
	{
		.key = "gsm.operator.iso-country",
		.value = "",
	},
	{
		.key = "gsm.operator.isroaming",
		.value = "false,false",
	},
	{
		.key = "gsm.operator.numeric",
		.value = "",
	},
	{
		.key = "gsm.operator.orig.alpha",
		.value = "",
	},
	{
		.key = "gsm.sim.operator.alpha",
		.value = ",",
	},
	{
		.key = "gsm.sim.operator.iso-country",
		.value = ",",
	},
	{
		.key = "gsm.sim.operator.numeric",
		.value = ",",
	},
	{
		.key = "gsm.sim.state",
		.value = "ABSENT,ABSENT",
	},
	{
		.key = "gsm.version.baseband1",
		.value = "-8976_GEN_PACK-1.66111.1.71302.1",
	},
	{
		.key = "gsm.version.baseband",
		.value = "-8976_GEN_PACK-1.66111.1.71302.1",
	},
	{
		.key = "gsm.version.ril-impl",
		.value = "Qualcomm RIL 1.0",
	},
	{
		.key = "hw.ad.mode",
		.value = "1",
	},
	{
		.key = "hw.cabl.version",
		.value = "2.0.20140905",
	},
	{
		.key = "hw.cabl.yuv",
		.value = "0",
	},
	{
		.key = "init.svc.RIDL",
		.value = "stopped",
	},
	{
		.key = "init.svc.adbd",
		.value = "running",
	},
	{
		.key = "init.svc.adsprpcd",
		.value = "running",
	},
	{
		.key = "init.svc.atfwd",
		.value = "running",
	},
	{
		.key = "init.svc.atmel_ts",
		.value = "stopped",
	},
	{
		.key = "init.svc.audiod",
		.value = "running",
	},
	{
		.key = "init.svc.bms-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.bootanim",
		.value = "stopped",
	},
	{
		.key = "init.svc.carrier_switcher",
		.value = "stopped",
	},
	{
		.key = "init.svc.checkpath",
		.value = "stopped",
	},
	{
		.key = "init.svc.checksdkpath",
		.value = "stopped",
	},
	{
		.key = "init.svc.cnd",
		.value = "running",
	},
	{
		.key = "init.svc.cnss-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.config-zram",
		.value = "stopped",
	},
	{
		.key = "init.svc.config_bluetooth",
		.value = "stopped",
	},
	{
		.key = "init.svc.cs-early-boot",
		.value = "stopped",
	},
	{
		.key = "init.svc.cs-post-boot",
		.value = "stopped",
	},
	{
		.key = "init.svc.debuggerd64",
		.value = "running",
	},
	{
		.key = "init.svc.debuggerd",
		.value = "running",
	},
	{
		.key = "init.svc.dhcpcd_wlan0",
		.value = "running",
	},
	{
		.key = "init.svc.displayfeature",
		.value = "running",
	},
	{
		.key = "init.svc.dpmd",
		.value = "running",
	},
	{
		.key = "init.svc.drm",
		.value = "running",
	},
	{
		.key = "init.svc.fdpp",
		.value = "running",
	},
	{
		.key = "init.svc.fidodaemon",
		.value = "running",
	},
	{
		.key = "init.svc.flash_recovery",
		.value = "stopped",
	},
	{
		.key = "init.svc.fpcd",
		.value = "stopped",
	},
	{
		.key = "init.svc.fpdaemon",
		.value = "running",
	},
	{
		.key = "init.svc.fuse_uicc0",
		.value = "running",
	},
	{
		.key = "init.svc.healthd",
		.value = "running",
	},
	{
		.key = "init.svc.hvdcp_opti",
		.value = "running",
	},
	{
		.key = "init.svc.ims_rtp_daemon",
		.value = "running",
	},
	{
		.key = "init.svc.imscmservice",
		.value = "running",
	},
	{
		.key = "init.svc.imsdatadaemon",
		.value = "running",
	},
	{
		.key = "init.svc.imsqmidaemon",
		.value = "running",
	},
	{
		.key = "init.svc.installd",
		.value = "running",
	},
	{
		.key = "init.svc.ipacm-diag",
		.value = "running",
	},
	{
		.key = "init.svc.ipacm",
		.value = "running",
	},
	{
		.key = "init.svc.irsc_util",
		.value = "stopped",
	},
	{
		.key = "init.svc.keystore",
		.value = "running",
	},
	{
		.key = "init.svc.lmkd",
		.value = "running",
	},
	{
		.key = "init.svc.loc_launcher",
		.value = "running",
	},
	{
		.key = "init.svc.logd",
		.value = "running",
	},
	{
		.key = "init.svc.mcd_init",
		.value = "stopped",
	},
	{
		.key = "init.svc.mcd_service",
		.value = "running",
	},
	{
		.key = "init.svc.mdbd",
		.value = "running",
	},
	{
		.key = "init.svc.media",
		.value = "running",
	},
	{
		.key = "init.svc.msm_irqbal_lb",
		.value = "running",
	},
	{
		.key = "init.svc.mtservice",
		.value = "running",
	},
	{
		.key = "init.svc.namespaceCreate",
		.value = "running",
	},
	{
		.key = "init.svc.netd",
		.value = "running",
	},
	{
		.key = "init.svc.netmgrd",
		.value = "running",
	},
	{
		.key = "init.svc.p2p_supplicant",
		.value = "running",
	},
	{
		.key = "init.svc.per_mgr",
		.value = "running",
	},
	{
		.key = "init.svc.perfd",
		.value = "running",
	},
	{
		.key = "init.svc.ppd",
		.value = "running",
	},
	{
		.key = "init.svc.qcamerasvr",
		.value = "running",
	},
	{
		.key = "init.svc.qcom-c_core-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-c_main-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-post-boot",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-usb-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcomsysd",
		.value = "running",
	},
	{
		.key = "init.svc.qfintverify",
		.value = "stopped",
	},
	{
		.key = "init.svc.qfp-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.qmuxd",
		.value = "running",
	},
	{
		.key = "init.svc.qseecomd",
		.value = "running",
	},
	{
		.key = "init.svc.qti",
		.value = "running",
	},
	{
		.key = "init.svc.ril-daemon2",
		.value = "running",
	},
	{
		.key = "init.svc.ril-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.rmt_storage",
		.value = "running",
	},
	{
		.key = "init.svc.sdcard",
		.value = "running",
	},
	{
		.key = "init.svc.sensors",
		.value = "running",
	},
	{
		.key = "init.svc.servicemanager",
		.value = "running",
	},
	{
		.key = "init.svc.setlockstate",
		.value = "stopped",
	},
	{
		.key = "init.svc.shelld",
		.value = "running",
	},
	{
		.key = "init.svc.ssService",
		.value = "running",
	},
	{
		.key = "init.svc.ss_ramdump",
		.value = "restarting",
	},
	{
		.key = "init.svc.ssr_setup",
		.value = "stopped",
	},
	{
		.key = "init.svc.surfaceflinger",
		.value = "running",
	},
	{
		.key = "init.svc.tftp_server",
		.value = "running",
	},
	{
		.key = "init.svc.thermal-engine",
		.value = "running",
	},
	{
		.key = "init.svc.time_daemon",
		.value = "running",
	},
	{
		.key = "init.svc.ueventd",
		.value = "running",
	},
	{
		.key = "init.svc.usb_uicc_daemon",
		.value = "stopped",
	},
	{
		.key = "init.svc.usb_uicc_enable",
		.value = "stopped",
	},
	{
		.key = "init.svc.vold",
		.value = "running",
	},
	{
		.key = "init.svc.wcnss-service",
		.value = "running",
	},
	{
		.key = "init.svc.wfdservice",
		.value = "running",
	},
	{
		.key = "init.svc.zygote",
		.value = "running",
	},
	{
		.key = "init.svc.zygote_secondary",
		.value = "running",
	},
	{
		.key = "keyguard.no_require_sim",
		.value = "true",
	},
	{
		.key = "media.aac_51_output_enabled",
		.value = "true",
	},
	{
		.key = "media.msm8956.version",
		.value = "1",
	},
	{
		.key = "media.msm8956hw",
		.value = "1",
	},
	{
		.key = "media.settings.xml",
		.value = "/etc/media_profiles_8956.xml",
	},
	{
		.key = "media.stagefright.enable-aac",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-fma2dp",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-http",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-player",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-qcp",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-scan",
		.value = "true",
	},
	{
		.key = "media.stagefright.use-awesome",
		.value = "false",
	},
	{
		.key = "mm.enable.qcom_parser",
		.value = "1039359",
	},
	{
		.key = "mm.enable.smoothstreaming",
		.value = "true",
	},
	{
		.key = "mmp.enable.3g2",
		.value = "true",
	},
	{
		.key = "net.bt.name",
		.value = "Android",
	},
	{
		.key = "net.change",
		.value = "net.dns2",
	},
	{
		.key = "net.dns1",
		.value = "208.67.222.222",
	},
	{
		.key = "net.dns2",
		.value = "208.67.220.220",
	},
	{
		.key = "net.hostname",
		.value = "RedmiNote3-Redmi",
	},
	{
		.key = "net.qtaguid_enabled",
		.value = "1",
	},
	{
		.key = "net.tcp.2g_init_rwnd",
		.value = "10",
	},
	{
		.key = "net.tcp.buffersize.default",
		.value = "4096,87380,524288,4096,16384,110208",
	},
	{
		.key = "net.tcp.buffersize.edge",
		.value = "4093,26280,35040,4096,16384,35040",
	},
	{
		.key = "net.tcp.buffersize.evdo",
		.value = "4094,87380,524288,4096,16384,262144",
	},
	{
		.key = "net.tcp.buffersize.gprs",
		.value = "4092,8760,11680,4096,8760,11680",
	},
	{
		.key = "net.tcp.buffersize.hsdpa",
		.value = "4094,87380,1220608,4096,16384,1220608",
	},
	{
		.key = "net.tcp.buffersize.hspa",
		.value = "4094,87380,1220608,4096,16384,1220608",
	},
	{
		.key = "net.tcp.buffersize.hspap",
		.value = "4094,87380,1220608,4096,16384,1220608",
	},
	{
		.key = "net.tcp.buffersize.hsupa",
		.value = "4094,87380,1220608,4096,16384,1220608",
	},
	{
		.key = "net.tcp.buffersize.lte",
		.value = "2097152,4194304,8388608,262144,524288,1048576",
	},
	{
		.key = "net.tcp.buffersize.umts",
		.value = "4094,87380,110208,4096,16384,110208",
	},
	{
		.key = "net.tcp.buffersize.wifi",
		.value = "524288,2097152,4194304,262144,524288,1048576",
	},
	{
		.key = "net.tcp.default_init_rwnd",
		.value = "60",
	},
	{
		.key = "partition.system.verified",
		.value = "1",
	},
	{
		.key = "persist.audio.dirac.speaker",
		.value = "true",
	},
	{
		.key = "persist.audio.fluence.audiorec",
		.value = "false",
	},
	{
		.key = "persist.audio.fluence.speaker",
		.value = "true",
	},
	{
		.key = "persist.audio.fluence.spk.mono",
		.value = "true",
	},
	{
		.key = "persist.audio.fluence.voicecall",
		.value = "true",
	},
	{
		.key = "persist.audio.fluence.voicerec",
		.value = "true",
	},
	{
		.key = "persist.audio.init_volume_index",
		.value = "1",
	},
	{
		.key = "persist.audio.vns.mode",
		.value = "2",
	},
	{
		.key = "persist.camera.stats.test",
		.value = "5",
	},
	{
		.key = "persist.cne.feature",
		.value = "1",
	},
	{
		.key = "persist.data.mode",
		.value = "concurrent",
	},
	{
		.key = "persist.data.netmgrd.qos.enable",
		.value = "true",
	},
	{
		.key = "persist.dbg.volte_avail_ovr",
		.value = "1",
	},
	{
		.key = "persist.dbg.vt_avail_ovr",
		.value = "1",
	},
	{
		.key = "persist.debug.8976.config",
		.value = "true",
	},
	{
		.key = "persist.debug.coresight.config",
		.value = "stm-events",
	},
	{
		.key = "persist.debug.wfd.enable",
		.value = "1",
	},
	{
		.key = "persist.demo.hdmirotationlock",
		.value = "false",
	},
	{
		.key = "persist.dpm.feature",
		.value = "7",
	},
	{
		.key = "persist.dpm.nsrm.bkg.evt",
		.value = "16251",
	},
	{
		.key = "persist.fuse_sdcard",
		.value = "true",
	},
	{
		.key = "persist.gps.qc_nlp_in_use",
		.value = "1",
	},
	{
		.key = "persist.hwc.downscale_threshold",
		.value = "1.15",
	},
	{
		.key = "persist.hwc.enable_vds",
		.value = "1",
	},
	{
		.key = "persist.hwc.mdpcomp.enable",
		.value = "true",
	},
	{
		.key = "persist.loc.nlp_name",
		.value = "com.qualcomm.location",
	},
	{
		.key = "persist.power.useautobrightadj",
		.value = "true",
	},
	{
		.key = "persist.qfp",
		.value = "false",
	},
	{
		.key = "persist.radio.NO_STAPA",
		.value = "1",
	},
	{
		.key = "persist.radio.adb_log_on",
		.value = "0",
	},
	{
		.key = "persist.radio.apm_sim_not_pwdn",
		.value = "1",
	},
	{
		.key = "persist.radio.calls.on.ims",
		.value = "0",
	},
	{
		.key = "persist.radio.cs_srv_type",
		.value = "1",
	},
	{
		.key = "persist.radio.csvt.enabled",
		.value = "false",
	},
	{
		.key = "persist.radio.custom_ecc",
		.value = "1",
	},
	{
		.key = "persist.radio.eons.enabled",
		.value = "false",
	},
	{
		.key = "persist.radio.force_on_dc",
		.value = "true",
	},
	{
		.key = "persist.radio.iccid_0",
		.value = "absent",
	},
	{
		.key = "persist.radio.iccid_1",
		.value = "absent",
	},
	{
		.key = "persist.radio.ignore_dom_time",
		.value = "5",
	},
	{
		.key = "persist.radio.jbims",
		.value = "0",
	},
	{
		.key = "persist.radio.msim.stackid_0",
		.value = "0",
	},
	{
		.key = "persist.radio.msim.stackid_1",
		.value = "1",
	},
	{
		.key = "persist.radio.mt_sms_ack",
		.value = "20",
	},
	{
		.key = "persist.radio.multisim.config",
		.value = "dsds",
	},
	{
		.key = "persist.radio.rat_on",
		.value = "combine",
	},
	{
		.key = "persist.radio.redir_party_num",
		.value = "0",
	},
	{
		.key = "persist.radio.restore_mode_pref",
		.value = "1",
	},
	{
		.key = "persist.radio.ril_payload_on",
		.value = "0",
	},
	{
		.key = "persist.radio.sglte_target",
		.value = "0",
	},
	{
		.key = "persist.radio.sib16_support",
		.value = "1",
	},
	{
		.key = "persist.radio.stack_id_0",
		.value = "0",
	},
	{
		.key = "persist.radio.stack_id_1",
		.value = "1",
	},
	{
		.key = "persist.radio.start_ota_daemon",
		.value = "1",
	},
	{
		.key = "persist.rild.nitz_long_ons_0",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_long_ons_1",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_long_ons_2",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_long_ons_3",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_plmn",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_short_ons_0",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_short_ons_1",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_short_ons_2",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_short_ons_3",
		.value = "",
	},
	{
		.key = "persist.service.bdroid.bdaddr",
		.value = "22:22:42:83:c4:4f",
	},
	{
		.key = "persist.service.logd.enable",
		.value = "",
	},
	{
		.key = "persist.sys.button_jack_profile",
		.value = "volume",
	},
	{
		.key = "persist.sys.button_jack_switch",
		.value = "0",
	},
	{
		.key = "persist.sys.cnd.iwlan",
		.value = "1",
	},
	{
		.key = "persist.sys.country",
		.value = "US",
	},
	{
		.key = "persist.sys.dalvik.vm.lib.2",
		.value = "libart.so",
	},
	{
		.key = "persist.sys.display_eyecare",
		.value = "0",
	},
	{
		.key = "persist.sys.dpmd.nsrm",
		.value = "3",
	},
	{
		.key = "persist.sys.fp.goodix",
		.value = "1",
	},
	{
		.key = "persist.sys.klo.rec_start",
		.value = "1506123385",
	},
	{
		.key = "persist.sys.klo",
		.value = "on",
	},
	{
		.key = "persist.sys.language",
		.value = "en",
	},
	{
		.key = "persist.sys.localevar",
		.value = "",
	},
	{
		.key = "persist.sys.ltm_enable",
		.value = "true",
	},
	{
		.key = "persist.sys.mcd_config_file",
		.value = "/system/etc/mcd_default.conf",
	},
	{
		.key = "persist.sys.memctrl",
		.value = "on",
	},
	{
		.key = "persist.sys.mitalk.enable",
		.value = "true",
	},
	{
		.key = "persist.sys.profiler_ms",
		.value = "0",
	},
	{
		.key = "persist.sys.released",
		.value = "true",
	},
	{
		.key = "persist.sys.screenshot_mode",
		.value = "0",
	},
	{
		.key = "persist.sys.silent",
		.value = "0",
	},
	{
		.key = "persist.sys.smartcover_enabled",
		.value = "false",
	},
	{
		.key = "persist.sys.smartcover_mode",
		.value = "1",
	},
	{
		.key = "persist.sys.ssr.enable_ramdumps",
		.value = "1",
	},
	{
		.key = "persist.sys.ssr.restart_level",
		.value = "modem",
	},
	{
		.key = "persist.sys.sw.firstLaunch",
		.value = "false",
	},
	{
		.key = "persist.sys.timezone",
		.value = "Asia/Shanghai",
	},
	{
		.key = "persist.sys.usb.config.extra",
		.value = "none",
	},
	{
		.key = "persist.sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "persist.sys.whetstone.level",
		.value = "2",
	},
	{
		.key = "persist.timed.enable",
		.value = "true",
	},
	{
		.key = "persist.ts.postmakeup",
		.value = "true",
	},
	{
		.key = "persist.ts.rtmakeup",
		.value = "true",
	},
	{
		.key = "qcom.hw.aac.encoder",
		.value = "true",
	},
	{
		.key = "qemu.hw.mainkeys",
		.value = "1",
	},
	{
		.key = "ril.ecclist1",
		.value = "911,*911,#911,112,000,08,110,999,118,119,120",
	},
	{
		.key = "ril.ecclist",
		.value = "911,*911,#911,112,000,08,110,999,118,119,120",
	},
	{
		.key = "ril.qcril_pre_init_lock_held",
		.value = "0",
	},
	{
		.key = "ril.subscription.types",
		.value = "RUIM",
	},
	{
		.key = "rild.libargs",
		.value = "-d /dev/smd0",
	},
	{
		.key = "rild.libpath",
		.value = "/vendor/lib64/libril-qc-qmi-1.so",
	},
	{
		.key = "ro.adb.secure",
		.value = "1",
	},
	{
		.key = "ro.alarm_boot",
		.value = "false",
	},
	{
		.key = "ro.allow.mock.location",
		.value = "0",
	},
	{
		.key = "ro.am.reschedule_service",
		.value = "true",
	},
	{
		.key = "ro.baseband",
		.value = "msm",
	},
	{
		.key = "ro.bluetooth.dun",
		.value = "true",
	},
	{
		.key = "ro.bluetooth.hfp.ver",
		.value = "1.7",
	},
	{
		.key = "ro.bluetooth.sap",
		.value = "true",
	},
	{
		.key = "ro.board.platform",
		.value = "msm8952",
	},
	{
		.key = "ro.boot.authorized_kernel",
		.value = "true",
	},
	{
		.key = "ro.boot.baseband",
		.value = "msm",
	},
	{
		.key = "ro.boot.boardID",
		.value = "2",
	},
	{
		.key = "ro.boot.bootdevice",
		.value = "7824900.sdhci",
	},
	{
		.key = "ro.boot.console",
		.value = "ttyHSL0",
	},
	{
		.key = "ro.boot.emmc",
		.value = "true",
	},
	{
		.key = "ro.boot.hardware",
		.value = "qcom",
	},
	{
		.key = "ro.boot.serialno",
		.value = "f9a3a4b2",
	},
	{
		.key = "ro.bootloader",
		.value = "unknown",
	},
	{
		.key = "ro.bootmode",
		.value = "unknown",
	},
	{
		.key = "ro.build.characteristics",
		.value = "nosdcard",
	},
	{
		.key = "ro.build.date.utc",
		.value = "1480048759",
	},
	{
		.key = "ro.build.date",
		.value = "Fri Nov 25 12:39:19 CST 2016",
	},
	{
		.key = "ro.build.description",
		.value = "kenzo-user 5.1.1 LMY47V V8.0.7.0.LHOCNDG release-keys",
	},
	{
		.key = "ro.build.device.ninur",
		.value = "64687",
	},
	{
		.key = "ro.build.display.hardware",
		.value = "",
	},
	{
		.key = "ro.build.display.id",
		.value = "LMY47V",
	},
	{
		.key = "ro.build.fingerprint",
		.value = "Xiaomi/kenzo/kenzo:5.1.1/LMY47V/V8.0.7.0.LHOCNDG:user/release-keys",
	},
	{
		.key = "ro.build.flavor",
		.value = "kenzo-user",
	},
	{
		.key = "ro.build.hardware.version",
		.value = "M850_D2-2",
	},
	{
		.key = "ro.build.host",
		.value = "c3-miui-ota-bd72.bj",
	},
	{
		.key = "ro.build.id",
		.value = "LMY47V",
	},
	{
		.key = "ro.build.network.type",
		.value = "",
	},
	{
		.key = "ro.build.product",
		.value = "kenzo",
	},
	{
		.key = "ro.build.project",
		.value = "",
	},
	{
		.key = "ro.build.tags",
		.value = "release-keys",
	},
	{
		.key = "ro.build.type",
		.value = "user",
	},
	{
		.key = "ro.build.user",
		.value = "builder",
	},
	{
		.key = "ro.build.version.all_codenames",
		.value = "REL",
	},
	{
		.key = "ro.build.version.base_os",
		.value = "",
	},
	{
		.key = "ro.build.version.bsp",
		.value = "0.5.3_0907",
	},
	{
		.key = "ro.build.version.codename",
		.value = "REL",
	},
	{
		.key = "ro.build.version.external",
		.value = "MI_M866",
	},
	{
		.key = "ro.build.version.incremental",
		.value = "V8.0.7.0.LHOCNDG",
	},
	{
		.key = "ro.build.version.internal",
		.value = "MI_C0907_00_A",
	},
	{
		.key = "ro.build.version.release",
		.value = "5.1.1",
	},
	{
		.key = "ro.build.version.sdk",
		.value = "22",
	},
	{
		.key = "ro.build.version.security_patch",
		.value = "2016-11-01",
	},
	{
		.key = "ro.carrier",
		.value = "unknown",
	},
	{
		.key = "ro.com.android.dataroaming",
		.value = "false",
	},
	{
		.key = "ro.com.android.dateformat",
		.value = "MM-dd-yyyy",
	},
	{
		.key = "ro.com.android.mobiledata",
		.value = "false",
	},
	{
		.key = "ro.com.google.clientidbase",
		.value = "android-xiaomi",
	},
	{
		.key = "ro.config.alarm_alert",
		.value = "Alarm_Classic.ogg",
	},
	{
		.key = "ro.config.elder-ringtone",
		.value = "Angel.mp3",
	},
	{
		.key = "ro.config.notification_sound",
		.value = "pixiedust.ogg",
	},
	{
		.key = "ro.config.ringtone",
		.value = "Ring_Synth_04.ogg",
	},
	{
		.key = "ro.config.sms_delivered_sound",
		.value = "MessageComplete.ogg",
	},
	{
		.key = "ro.config.sms_received_sound",
		.value = "FadeIn.ogg",
	},
	{
		.key = "ro.config.zram",
		.value = "true",
	},
	{
		.key = "ro.core_ctl_max_cpu",
		.value = "4",
	},
	{
		.key = "ro.core_ctl_min_cpu",
		.value = "2",
	},
	{
		.key = "ro.crypto.state",
		.value = "unencrypted",
	},
	{
		.key = "ro.cutoff_voltage_mv",
		.value = "3200",
	},
	{
		.key = "ro.dalvik.vm.native.bridge",
		.value = "0",
	},
	{
		.key = "ro.dbg.coresight.cfg_file",
		.value = "/system/etc/init.qcom.debug.sh",
	},
	{
		.key = "ro.debuggable",
		.value = "0",
	},
	{
		.key = "ro.earlyboot_cpus",
		.value = "unknown",
	},
	{
		.key = "ro.factorytest",
		.value = "0",
	},
	{
		.key = "ro.fm.transmitter",
		.value = "false",
	},
	{
		.key = "ro.frp.pst",
		.value = "/dev/block/bootdevice/by-name/config",
	},
	{
		.key = "ro.gps.agps_provider",
		.value = "1",
	},
	{
		.key = "ro.hardware",
		.value = "qcom",
	},
	{
		.key = "ro.hwui.text_large_cache_height",
		.value = "2048",
	},
	{
		.key = "ro.hwui.texture_cache_size",
		.value = "40",
	},
	{
		.key = "ro.miui.cust_variant",
		.value = "cn",
	},
	{
		.key = "ro.miui.has_cust_partition",
		.value = "true",
	},
	{
		.key = "ro.miui.has_handy_mode_sf",
		.value = "1",
	},
	{
		.key = "ro.miui.has_real_blur",
		.value = "1",
	},
	{
		.key = "ro.miui.mcc",
		.value = "9460",
	},
	{
		.key = "ro.miui.mnc",
		.value = "9999",
	},
	{
		.key = "ro.miui.region",
		.value = "CN",
	},
	{
		.key = "ro.miui.ui.version.code",
		.value = "6",
	},
	{
		.key = "ro.miui.ui.version.name",
		.value = "V8",
	},
	{
		.key = "ro.miui.version.code_time",
		.value = "1469635200",
	},
	{
		.key = "ro.opengles.version",
		.value = "196609",
	},
	{
		.key = "ro.pip.gated",
		.value = "0",
	},
	{
		.key = "ro.product.board",
		.value = "msm8952",
	},
	{
		.key = "ro.product.brand",
		.value = "Xiaomi",
	},
	{
		.key = "ro.product.cpu.abi",
		.value = "arm64-v8a",
	},
	{
		.key = "ro.product.cpu.abilist32",
		.value = "armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.cpu.abilist64",
		.value = "arm64-v8a",
	},
	{
		.key = "ro.product.cpu.abilist",
		.value = "arm64-v8a,armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.cuptsm",
		.value = "XIAOMI|ESE|02|01",
	},
	{
		.key = "ro.product.device",
		.value = "kenzo",
	},
	{
		.key = "ro.product.locale.language",
		.value = "zh",
	},
	{
		.key = "ro.product.locale.region",
		.value = "CN",
	},
	{
		.key = "ro.product.manufacturer",
		.value = "Xiaomi",
	},
	{
		.key = "ro.product.model",
		.value = "Redmi Note 3",
	},
	{
		.key = "ro.product.name",
		.value = "kenzo",
	},
	{
		.key = "ro.qc.sdk.audio.fluencetype",
		.value = "fluence",
	},
	{
		.key = "ro.qc.sdk.audio.ssr",
		.value = "false",
	},
	{
		.key = "ro.qcom.ad.calib.data",
		.value = "/system/etc/calib.cfg",
	},
	{
		.key = "ro.qcom.ad.sensortype",
		.value = "2",
	},
	{
		.key = "ro.qcom.ad",
		.value = "1",
	},
	{
		.key = "ro.qualcomm.bluetooth.ftp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.hfp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.hsp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.map",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.nap",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.opp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.pbap",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bt.hci_transport",
		.value = "smd",
	},
	{
		.key = "ro.qualcomm.cabl",
		.value = "0",
	},
	{
		.key = "ro.revision",
		.value = "0",
	},
	{
		.key = "ro.ril.miui.imei0",
		.value = "862305033675588",
	},
	{
		.key = "ro.ril.miui.imei1",
		.value = "862305033675588",
	},
	{
		.key = "ro.ril.miui.imei",
		.value = ",862305033675588",
	},
	{
		.key = "ro.ril.svdo",
		.value = "false",
	},
	{
		.key = "ro.ril.svlte1x",
		.value = "false",
	},
	{
		.key = "ro.runtime.firstboot",
		.value = "1524188767192",
	},
	{
		.key = "ro.secure",
		.value = "1",
	},
	{
		.key = "ro.secureboot.devicelock",
		.value = "1",
	},
	{
		.key = "ro.secureboot.lockstate",
		.value = "locked",
	},
	{
		.key = "ro.serialno",
		.value = "f9a3a4b2",
	},
	{
		.key = "ro.sf.lcd_density",
		.value = "480",
	},
	{
		.key = "ro.ss.nohidden",
		.value = "true",
	},
	{
		.key = "ro.ss.version",
		.value = "3.4.106",
	},
	{
		.key = "ro.sys.ft_whole_anim",
		.value = "true",
	},
	{
		.key = "ro.sys.fw.bservice_age",
		.value = "5000",
	},
	{
		.key = "ro.sys.fw.bservice_enable",
		.value = "true",
	},
	{
		.key = "ro.sys.fw.bservice_limit",
		.value = "5",
	},
	{
		.key = "ro.sys.fw.dex2oat_thread_count",
		.value = "4",
	},
	{
		.key = "ro.sys.fw.empty_app_percent",
		.value = "50",
	},
	{
		.key = "ro.sys.fw.trim_cache_percent",
		.value = "100",
	},
	{
		.key = "ro.sys.fw.trim_empty_percent",
		.value = "100",
	},
	{
		.key = "ro.sys.fw.trim_enable_memory",
		.value = "2147483648",
	},
	{
		.key = "ro.sys.fw.use_trim_settings",
		.value = "true",
	},
	{
		.key = "ro.sys.usb.default.config",
		.value = "diag,serial_smd,rmnet_ipa,adb",
	},
	{
		.key = "ro.telephony.call_ring.multiple",
		.value = "false",
	},
	{
		.key = "ro.telephony.cm_blklst_on",
		.value = "0",
	},
	{
		.key = "ro.telephony.default_network",
		.value = "22",
	},
	{
		.key = "ro.use_data_netmgrd",
		.value = "true",
	},
	{
		.key = "ro.vendor.at_library",
		.value = "libqti-at.so",
	},
	{
		.key = "ro.vendor.extension_library",
		.value = "libqti-perfd-client.so",
	},
	{
		.key = "ro.vendor.gt_library",
		.value = "libqti-gt.so",
	},
	{
		.key = "ro.wifi.channels",
		.value = "",
	},
	{
		.key = "ro.zygote",
		.value = "zygote64_32",
	},
	{
		.key = "sched.colocate.enable",
		.value = "1",
	},
	{
		.key = "selinux.reload_policy",
		.value = "1",
	},
	{
		.key = "service.bootanim.exit",
		.value = "1",
	},
	{
		.key = "sys.boot_completed",
		.value = "1",
	},
	{
		.key = "sys.ims.DATA_DAEMON_STATUS",
		.value = "1",
	},
	{
		.key = "sys.ims.QMI_DAEMON_STATUS",
		.value = "1",
	},
	{
		.key = "sys.is_keyguard_showing",
		.value = "0",
	},
	{
		.key = "sys.keyguard.bleunlock",
		.value = "true",
	},
	{
		.key = "sys.keymaster.loaded",
		.value = "true",
	},
	{
		.key = "sys.listeners.registered",
		.value = "true",
	},
	{
		.key = "sys.panel.color",
		.value = "3435383200000000",
	},
	{
		.key = "sys.settings_global_version",
		.value = "3",
	},
	{
		.key = "sys.settings_system_version",
		.value = "10",
	},
	{
		.key = "sys.sysctl.extra_free_kbytes",
		.value = "24300",
	},
	{
		.key = "sys.sysctl.tcp_adv_win_scale",
		.value = "2",
	},
	{
		.key = "sys.sysctl.tcp_def_init_rwnd",
		.value = "60",
	},
	{
		.key = "sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "sys.usb.rps_mask",
		.value = "0",
	},
	{
		.key = "sys.usb.state",
		.value = "mtp,adb",
	},
	{
		.key = "sys.usb_uicc.enabled",
		.value = "0",
	},
	{
		.key = "sys.usb_uicc.loading",
		.value = "1",
	},
	{
		.key = "telephony.lteOnCdmaDevice",
		.value = "1",
	},
	{
		.key = "tunnel.audio.encode",
		.value = "false",
	},
	{
		.key = "use.voice.path.for.pcm.voip",
		.value = "true",
	},
	{
		.key = "vidc.enc.dcvs.extra-buff-count",
		.value = "2",
	},
	{
		.key = "vidc.enc.narrow.searchrange",
		.value = "1",
	},
	{
		.key = "voice.conc.fallbackpath",
		.value = "deep-buffer",
	},
	{
		.key = "voice.playback.conc.disabled",
		.value = "true",
	},
	{
		.key = "voice.record.conc.disabled",
		.value = "false",
	},
	{
		.key = "voice.voip.conc.disabled",
		.value = "true",
	},
	{
		.key = "vold.pfe",
		.value = "deactivated",
	},
	{
		.key = "vold.post_fs_data_done",
		.value = "1",
	},
	{
		.key = "wifi.interface",
		.value = "wlan0",
	},
	{
		.key = "wlan.driver.ath",
		.value = "0",
	},
	{
		.key = "wlan.driver.config",
		.value = "/data/misc/wifi/WCNSS_qcom_cfg.ini",
	},
	{
		.key = "wlan.driver.status",
		.value = "ok",
	},
	{ NULL },
};
#endif /* __ANDROID__ */
