/*
 * Decompiled with CFR 0.152.
 */
package org.tuckey.web.filters.urlrewrite;

import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import javax.servlet.http.Cookie;
import junit.framework.TestCase;
import org.tuckey.web.MockRequest;
import org.tuckey.web.filters.urlrewrite.Condition;
import org.tuckey.web.filters.urlrewrite.utils.Log;

public class ConditionTest
extends TestCase {
    public void setUp() {
        Log.setLevel("DEBUG");
    }

    public void testValue() {
        Condition condition = new Condition();
        condition.setValue("tEster");
        ConditionTest.assertEquals((String)"tEster", (String)condition.getValue());
    }

    public void testName() {
        Condition condition = new Condition();
        condition.setName("mename");
        ConditionTest.assertEquals((String)"mename", (String)condition.getName());
    }

    public void testType() {
        this.typeSpecific("time");
        this.typeSpecific("year");
        this.typeSpecific("month");
        this.typeSpecific("dayofmonth");
        this.typeSpecific("dayofweek");
        this.typeSpecific("ampm");
        this.typeSpecific("hourofday");
        this.typeSpecific("minute");
        this.typeSpecific("second");
        this.typeSpecific("millisecond");
        this.typeSpecific("attribute");
        this.typeSpecific("auth-type");
        this.typeSpecific("character-encoding");
        this.typeSpecific("content-length");
        this.typeSpecific("content-type");
        this.typeSpecific("context-path");
        this.typeSpecific("cookie");
        this.typeSpecific("header");
        this.typeSpecific("method");
        this.typeSpecific("parameter");
        this.typeSpecific("path-info");
        this.typeSpecific("path-translated");
        this.typeSpecific("protocol");
        this.typeSpecific("query-string");
        this.typeSpecific("remote-addr");
        this.typeSpecific("remote-host");
        this.typeSpecific("remote-user");
        this.typeSpecific("requested-session-id");
        this.typeSpecific("request-uri");
        this.typeSpecific("request-url");
        this.typeSpecific("session-attribute");
        this.typeSpecific("session-isnew");
        this.typeSpecific("port");
        this.typeSpecific("server-name");
        this.typeSpecific("scheme");
        this.typeSpecific("user-in-role");
    }

    public void typeSpecific(String type) {
        Condition condition = new Condition();
        condition.setType(type);
        ConditionTest.assertEquals((String)type, (String)condition.getType());
        MockRequest request = new MockRequest();
        condition.initialise();
        condition.matches(request);
    }

    public void testCompileFailure() {
        Condition condition = new Condition();
        condition.setValue("aaa[");
        ConditionTest.assertFalse((String)"regexp shouldn't compile", (boolean)condition.initialise());
    }

    public void testOperator() {
        Condition condition = new Condition();
        condition.setOperator("");
        ConditionTest.assertEquals((String)"equal", (String)condition.getOperator());
    }

    public void testNext() {
        Condition condition = new Condition();
        condition.setNext("and");
        ConditionTest.assertEquals((String)"and", (String)condition.getNext());
        Condition condition2 = new Condition();
        condition2.setNext("badand");
        ConditionTest.assertFalse((String)"must not init", (boolean)condition.initialise());
        Condition condition3 = new Condition();
        condition3.setNext("or");
        ConditionTest.assertEquals((String)"or", (String)condition3.getNext());
        ConditionTest.assertTrue((boolean)condition3.isProcessNextOr());
    }

    public void testUnItied() {
        Condition condition = new Condition();
        ConditionTest.assertFalse((boolean)condition.matches(new MockRequest()));
    }

    public void testCaseSensitive() {
        Condition condition = new Condition();
        condition.setType("header");
        condition.setName("a");
        condition.setValue("aaa");
        condition.setCaseSensitive(true);
        condition.initialise();
        MockRequest request = new MockRequest();
        request.setHeader("a", "aAa");
        ConditionTest.assertFalse((boolean)condition.matches(request));
        request.setHeader("a", "aaa");
        ConditionTest.assertTrue((boolean)condition.matches(request));
        ConditionTest.assertTrue((boolean)condition.isCaseSensitive());
    }

    public void testInvalid() {
        Condition condition = new Condition();
        condition.setType("bogus");
        condition.initialise();
        ConditionTest.assertFalse((boolean)condition.matches(new MockRequest()));
    }

    public void testId() {
        Condition condition = new Condition();
        condition.setId(98);
        ConditionTest.assertTrue((condition.getId() == 98 ? 1 : 0) != 0);
    }

    public void testConditionOperator() {
        MockRequest request = new MockRequest();
        request.setServerPort(10);
        Condition condition = new Condition();
        condition.setType("port");
        condition.setValue("9");
        condition.setOperator("greater");
        condition.initialise();
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
        Condition condition2 = new Condition();
        condition2.setType("port");
        condition2.setValue("11");
        condition2.setOperator("less");
        condition2.initialise();
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition2.matches(request));
        Condition condition3 = new Condition();
        condition3.setType("port");
        condition3.setValue("10");
        condition3.setOperator("greaterorequal");
        condition3.initialise();
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition3.matches(request));
        Condition condition4 = new Condition();
        condition4.setType("port");
        condition4.setValue("10");
        condition4.setOperator("lessorequal");
        condition4.initialise();
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition4.matches(request));
        Condition condition5 = new Condition();
        condition5.setType("port");
        condition5.setValue("99");
        condition5.setOperator("notequal");
        condition5.initialise();
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition5.matches(request));
        Condition condition6 = new Condition();
        condition6.setType("method");
        condition6.setValue("POST");
        condition6.setOperator("notequal");
        condition6.initialise();
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition6.matches(request));
        Condition condition7 = new Condition();
        condition7.setType("method");
        condition7.setValue("POST");
        condition7.setOperator("somebadassop");
        ConditionTest.assertFalse((String)"condition must not init", (boolean)condition7.initialise());
        ConditionTest.assertTrue((String)"condition must have error", (condition7.getError() != null ? 1 : 0) != 0);
    }

    public void testConditionTime() {
        MockRequest request = new MockRequest();
        long field = System.currentTimeMillis();
        Condition condition = new Condition();
        condition.setType("time");
        condition.setValue("" + field);
        condition.setOperator("greaterorequal");
        condition.initialise();
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
    }

    public void testConditionYear() {
        MockRequest request = new MockRequest();
        Calendar cal = Calendar.getInstance();
        int field = cal.get(1);
        Condition condition = new Condition();
        condition.setType("year");
        condition.setValue("" + field);
        condition.initialise();
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
    }

    public void testConditionMonth() {
        MockRequest request = new MockRequest();
        Calendar cal = Calendar.getInstance();
        int field = cal.get(2);
        Condition condition = new Condition();
        condition.setType("month");
        condition.setValue("" + field);
        condition.initialise();
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
    }

    public void testConditionDayOfMonth() {
        MockRequest request = new MockRequest();
        Calendar cal = Calendar.getInstance();
        int field = cal.get(5);
        Condition condition = new Condition();
        condition.setType("dayofmonth");
        condition.setValue("" + field);
        condition.initialise();
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
    }

    public void testConditionDayOfWeek() {
        MockRequest request = new MockRequest();
        Calendar cal = Calendar.getInstance();
        int field = cal.get(7);
        Condition condition = new Condition();
        condition.setType("dayofweek");
        condition.setValue("" + field);
        condition.initialise();
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
    }

    public void testConditionAmPm() {
        MockRequest request = new MockRequest();
        Calendar cal = Calendar.getInstance();
        int field = cal.get(9);
        Condition condition = new Condition();
        condition.setType("ampm");
        condition.setValue("" + field);
        condition.initialise();
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
    }

    public void testConditionHourOfDay() {
        MockRequest request = new MockRequest();
        Calendar cal = Calendar.getInstance();
        int field = cal.get(11);
        Condition condition = new Condition();
        condition.setType("hourofday");
        condition.setValue("" + field);
        condition.initialise();
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
    }

    public void testConditionMinute() {
        MockRequest request = new MockRequest();
        Calendar cal = Calendar.getInstance();
        int field = cal.get(12);
        Condition condition = new Condition();
        condition.setType("minute");
        condition.setValue("" + field);
        condition.initialise();
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
    }

    public void testConditionSecond() {
        MockRequest request = new MockRequest();
        Calendar cal = Calendar.getInstance();
        int field = cal.get(13);
        Condition condition = new Condition();
        condition.setType("second");
        condition.setValue("" + field);
        condition.initialise();
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
    }

    public void testConditionMillisecond() {
        MockRequest request = new MockRequest();
        Calendar cal = Calendar.getInstance();
        int field = cal.get(14);
        Condition condition = new Condition();
        condition.setType("millisecond");
        condition.setValue("" + field);
        condition.setOperator("greaterorequal");
        condition.initialise();
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
    }

    public void testConditionAttribute() {
        MockRequest request = new MockRequest();
        Condition condition = new Condition();
        condition.setType("attribute");
        condition.setName("ray");
        condition.setValue("andchristian");
        condition.initialise();
        ConditionTest.assertFalse((String)"condition must not match", (boolean)condition.matches(request));
        request.setAttribute("ray", "andchristian");
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
        Condition condition2 = new Condition();
        condition2.setType("attribute");
        condition2.setName("ray");
        condition2.setValue("andbob");
        condition2.initialise();
        ConditionTest.assertFalse((String)"condition must not match", (boolean)condition2.matches(request));
        Condition condition3 = new Condition();
        condition3.setType("attribute");
        condition3.setValue("andbob");
        condition3.initialise();
        ConditionTest.assertFalse((String)"condition must not initialise", (boolean)condition3.matches(request));
    }

    public void testConditionAuthType() {
        MockRequest request = new MockRequest();
        request.setAuthType("pwdwithcrapasrot13");
        Condition condition = new Condition();
        condition.setType("auth-type");
        condition.setValue("pwd[a-z0-9]+");
        condition.initialise();
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
        Condition condition2 = new Condition();
        condition2.setType("auth-type");
        condition2.setValue("someotherpwdtype");
        condition2.initialise();
        ConditionTest.assertFalse((String)"condition must not match", (boolean)condition2.matches(request));
    }

    public void testConditionCharacterEncoding() throws UnsupportedEncodingException {
        MockRequest request = new MockRequest();
        Condition condition = new Condition();
        condition.setType("character-encoding");
        condition.setValue("utfcrazybig[0-9]+");
        condition.initialise();
        ConditionTest.assertFalse((String)"condition must not match", (boolean)condition.matches(request));
        request.setCharacterEncoding("utfcrazybig13");
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
    }

    public void testConditionContentLength() throws UnsupportedEncodingException {
        MockRequest request = new MockRequest();
        request.setContentLength(120);
        Condition condition = new Condition();
        condition.setType("content-length");
        condition.setValue("100");
        condition.setOperator("greater");
        condition.initialise();
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
        request.setContentLength(10);
        ConditionTest.assertFalse((String)"condition must not match", (boolean)condition.matches(request));
    }

    public void testContentType() throws UnsupportedEncodingException {
        MockRequest request = new MockRequest();
        request.setContentType("bottlesandcans");
        Condition condition = new Condition();
        condition.setType("content-type");
        condition.setValue("bott[a-z]+");
        condition.initialise();
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
        request.setContentType(null);
        ConditionTest.assertFalse((String)"condition must not match", (boolean)condition.matches(request));
    }

    public void testContextPath() throws UnsupportedEncodingException {
        MockRequest request = new MockRequest();
        request.setContextPath("blah");
        Condition condition = new Condition();
        condition.setType("context-path");
        condition.setValue("[a-b]lah");
        condition.initialise();
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
        request.setContextPath("qlah");
        ConditionTest.assertFalse((String)"condition must not match", (boolean)condition.matches(request));
    }

    public void testCookie() throws UnsupportedEncodingException {
        MockRequest request = new MockRequest();
        Condition condition = new Condition();
        condition.setType("cookie");
        condition.setName("tracker");
        condition.setValue(".*bass.*");
        condition.initialise();
        ConditionTest.assertFalse((String)"condition must not match", (boolean)condition.matches(request));
        request.addCookie(new Cookie("otherokie", "allyourbassisbelongtous"));
        ConditionTest.assertFalse((String)"condition must not match", (boolean)condition.matches(request));
        request.addCookie(new Cookie("tracker", "allyourbassisbelongtous"));
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
    }

    public void testLocalPort() throws UnsupportedEncodingException {
        MockRequest request = new MockRequest();
        request.setLocalPort(4);
        Condition condition = new Condition();
        condition.setType("local-port");
        condition.setValue("1004");
        condition.initialise();
        ConditionTest.assertFalse((String)"condition must not match", (boolean)condition.matches(request));
        request.setLocalPort(1004);
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
    }

    public void testParameter() throws UnsupportedEncodingException {
        MockRequest request = new MockRequest();
        Condition condition = new Condition();
        condition.setType("parameter");
        condition.setName("reqparam");
        condition.setValue("[0-9]+");
        condition.initialise();
        ConditionTest.assertFalse((String)"condition must not match", (boolean)condition.matches(request));
        request.addParameter("reqparam", "1000245");
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
    }

    public void testPathInfo() throws UnsupportedEncodingException {
        MockRequest request = new MockRequest();
        Condition condition = new Condition();
        condition.setType("path-info");
        condition.setValue("afr[aeiou]ca");
        condition.initialise();
        ConditionTest.assertFalse((String)"condition must not match", (boolean)condition.matches(request));
        request.setPathInfo("africa");
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
    }

    public void testPathTranslated() throws UnsupportedEncodingException {
        MockRequest request = new MockRequest();
        Condition condition = new Condition();
        condition.setType("path-translated");
        condition.setValue("/!@&");
        condition.initialise();
        ConditionTest.assertFalse((String)"condition must not match", (boolean)condition.matches(request));
        request.setPathTranslated("/!@&");
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
    }

    public void testProtocol() throws UnsupportedEncodingException {
        MockRequest request = new MockRequest();
        Condition condition = new Condition();
        condition.setType("protocol");
        condition.setValue("HTTP/1\\.[1-2]");
        condition.initialise();
        request.setProtocol("HTTP/2.0");
        ConditionTest.assertFalse((String)"condition must not match", (boolean)condition.matches(request));
        request.setProtocol("HTTP/1.2");
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
    }

    public void testQueryString() throws UnsupportedEncodingException {
        MockRequest request = new MockRequest();
        Condition condition = new Condition();
        condition.setType("query-string");
        condition.setValue(".*&param=[0-9]+.*");
        condition.initialise();
        ConditionTest.assertFalse((String)"condition must not match", (boolean)condition.matches(request));
        request.setQueryString("?aaa=dsdsd&param=2333&asdsa=sdds");
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
    }

    public void testRemoteAddr() throws UnsupportedEncodingException {
        MockRequest request = new MockRequest();
        Condition condition = new Condition();
        condition.setType("remote-addr");
        condition.setValue("192.168.[0-9]+.[0-9]+");
        condition.initialise();
        ConditionTest.assertFalse((String)"condition must not match", (boolean)condition.matches(request));
        request.setRemoteAddr("192.168.184.23");
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
    }

    public void testRemoteHost() throws UnsupportedEncodingException {
        MockRequest request = new MockRequest();
        Condition condition = new Condition();
        condition.setType("remote-host");
        condition.setValue("\\w+\\.tuckey.org");
        condition.initialise();
        ConditionTest.assertFalse((String)"condition must not match", (boolean)condition.matches(request));
        request.setRemoteHost("toaster.tuckey.org");
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
    }

    public void testRemoteUser() throws UnsupportedEncodingException {
        MockRequest request = new MockRequest();
        Condition condition = new Condition();
        condition.setType("remote-user");
        condition.setValue("p.\\w+");
        condition.initialise();
        ConditionTest.assertFalse((String)"condition must not match", (boolean)condition.matches(request));
        request.setRemoteUser("p.smith");
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
    }

    public void testRequestedSessionId() throws UnsupportedEncodingException {
        MockRequest request = new MockRequest();
        Condition condition = new Condition();
        condition.setType("requested-session-id");
        condition.setValue("\\w+\\.sec[0-6]+");
        condition.initialise();
        ConditionTest.assertFalse((String)"condition must not match", (boolean)condition.matches(request));
        request.setRequestedSessionId("sdfjsdfhkjhk897fd.sec03");
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
    }

    public void testRequestUri() throws UnsupportedEncodingException {
        MockRequest request = new MockRequest();
        Condition condition = new Condition();
        condition.setType("request-uri");
        condition.setValue("\\d");
        condition.initialise();
        ConditionTest.assertFalse((String)"condition must not match", (boolean)condition.matches(request));
        request.setRequestURI("2");
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
    }

    public void testRequestUrl() throws UnsupportedEncodingException {
        MockRequest request = new MockRequest();
        Condition condition = new Condition();
        condition.setType("request-url");
        condition.setValue("\\d");
        condition.initialise();
        ConditionTest.assertFalse((String)"condition must not match", (boolean)condition.matches(request));
        request.setRequestURL("2");
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
    }

    public void testSessionAttribute() throws UnsupportedEncodingException {
        MockRequest request = new MockRequest();
        Condition condition = new Condition();
        condition.setType("session-attribute");
        condition.setValue("someval");
        condition.initialise();
        ConditionTest.assertFalse((String)"condition must not match", (boolean)condition.matches(request));
        Condition condition2 = new Condition();
        condition2.setType("session-attribute");
        condition2.setName("someatt");
        condition2.setValue("someval");
        condition2.initialise();
        ConditionTest.assertFalse((String)"condition must not match", (boolean)condition2.matches(request));
        request.getSession(true).setAttribute("someatt", (Object)"someval");
        Condition condition3 = new Condition();
        condition3.setType("session-attribute");
        condition3.setName("someatt");
        condition3.setValue("someval");
        condition3.initialise();
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition3.matches(request));
    }

    public void testSessionIsNew() throws UnsupportedEncodingException {
        MockRequest request = new MockRequest();
        Condition condition = new Condition();
        condition.setType("session-isnew");
        condition.setValue("yes");
        condition.setOperator("notequal");
        condition.initialise();
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
        request.setSessionNew(true);
        ConditionTest.assertFalse((String)"condition must not match", (boolean)condition.matches(request));
    }

    public void testServerName() throws UnsupportedEncodingException {
        MockRequest request = new MockRequest();
        Condition condition = new Condition();
        condition.setType("server-name");
        condition.setValue("dev.*");
        condition.initialise();
        ConditionTest.assertFalse((String)"condition must not match", (boolean)condition.matches(request));
        request.setServerName("dev.googil.com");
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
    }

    public void testScheme() throws UnsupportedEncodingException {
        MockRequest request = new MockRequest();
        Condition condition = new Condition();
        condition.setType("scheme");
        condition.setValue("http");
        condition.initialise();
        ConditionTest.assertFalse((String)"condition must not match", (boolean)condition.matches(request));
        request.setScheme("http");
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
    }

    public void testConditionHeader() {
        MockRequest request = new MockRequest();
        Condition condition = new Condition();
        condition.setName("some header");
        condition.setValue("tester");
        condition.initialise();
        ConditionTest.assertFalse((String)"condition must not match", (boolean)condition.matches(request));
        request.setHeader("some header", "tester");
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
        Condition condition2 = new Condition();
        condition2.setName("  ");
        condition2.setValue("tester");
        ConditionTest.assertFalse((String)"condition must not initialise", (boolean)condition2.initialise());
        ConditionTest.assertFalse((String)"condition must not match", (boolean)condition2.matches(request));
        Condition condition3 = new Condition();
        condition3.setName("bonus");
        ConditionTest.assertTrue((String)"condition must initialise and check for exists", (boolean)condition3.initialise());
        ConditionTest.assertFalse((String)"condition must not match", (boolean)condition3.matches(request));
        request.setHeader("bonus", "tester");
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition3.matches(request));
        Condition condition4 = new Condition();
        condition4.setName("portashed");
        condition4.setOperator("notequal");
        ConditionTest.assertTrue((String)"condition must initialise and check for exists", (boolean)condition4.initialise());
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition4.matches(request));
        request.setHeader("portashed", "tester");
        ConditionTest.assertFalse((String)"condition must not match", (boolean)condition4.matches(request));
    }

    public void testConditionMethod() {
        MockRequest request = new MockRequest();
        request.setMethod("HEAD");
        Condition condition = new Condition();
        condition.setType("method");
        condition.setValue("H[A-Z]AD");
        condition.initialise();
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
    }

    public void testConditionIsUserInRole() {
        MockRequest request = new MockRequest();
        request.addRole("devil");
        Condition condition = new Condition();
        condition.setType("user-in-role");
        condition.setName("devil");
        condition.initialise();
        ConditionTest.assertTrue((String)"user should be in this role", (boolean)condition.matches(request));
        Condition condition2 = new Condition();
        condition2.setType("user-in-role");
        condition2.setName("angel");
        condition2.initialise();
        ConditionTest.assertFalse((String)"bad user in role must not match", (boolean)condition2.matches(request));
        Condition condition3 = new Condition();
        condition3.setType("user-in-role");
        condition3.setValue("devil");
        condition3.initialise();
        ConditionTest.assertTrue((String)"value instead of name should match", (boolean)condition3.matches(request));
        Condition condition4 = new Condition();
        condition4.setType("user-in-role");
        condition4.setValue("admin");
        condition4.setOperator("notequal");
        condition4.initialise();
        ConditionTest.assertTrue((String)"value instead of name should match", (boolean)condition4.matches(request));
    }

    public void testConditionPort() {
        MockRequest request = new MockRequest();
        request.setServerPort(9001);
        Condition condition = new Condition();
        condition.setType("port");
        condition.setValue("9001");
        condition.initialise();
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition.matches(request));
        Condition condition2 = new Condition();
        condition2.setType("port");
        condition2.setValue(" 9001");
        condition2.initialise();
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition2.matches(request));
        condition2.initialise();
        ConditionTest.assertTrue((String)"condition must match", (boolean)condition2.matches(request));
        Condition condition3 = new Condition();
        condition3.setType("port");
        condition3.setValue("aaa");
        condition3.initialise();
        ConditionTest.assertFalse((String)"condition must not match", (boolean)condition3.matches(request));
    }
}

