% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/branch.R
\name{is_branch}
\alias{is_branch}
\title{Check if object is \code{git_branch}}
\usage{
is_branch(object)
}
\arguments{
\item{object}{Check if object is of class \code{git_branch}}
}
\value{
TRUE if object is class \code{git_branch}, else FALSE
}
\description{
Check if object is \code{git_branch}
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user
config(repo, user.name = "Alice", user.email = "alice@example.org")

## Commit a text file
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

branch <- branches(repo)[[1]]

## Check if branch
is_branch(branch)
}
}
