% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_plot.R
\name{ts_data}
\alias{ts_data}
\title{Converts tweets data into time series-like data object.}
\usage{
ts_data(data, by = "days", trim = 0L, tz = "UTC")
}
\arguments{
\item{data}{Data frame or grouped data frame.}

\item{by}{Desired interval of time expressed as numeral plus one of
"secs", "mins", "hours", "days", "weeks", "months", or
"years". If a numeric is provided, the value is assumed to be in
seconds.}

\item{trim}{Number of observations to trim off the front and end of
each time series}

\item{tz}{Time zone to be used, defaults to "UTC" (Twitter default)}
}
\value{
Data frame with time, n, and grouping column if applicable.
}
\description{
Returns data containing the frequency of tweets over a specified
interval of time.
}
\examples{
if (auth_has_default()) {

## handles of women senators
orgs <- c("_R_Foundation", "ropensci")

## get timelines for each
orgs_tml <- get_timeline(orgs, n = 100)

## get single time series for tweets
ts_data(orgs_tml)

## using weekly intervals
ts_data(orgs_tml, "weeks")
}

}
