dnl -*- Autoconf -*-
dnl Copyright (C) 1993-2004, 2007-2008, 2017, 2021 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Bruno Haible, Marcus Daniels, Sam Steingold.

AC_PREREQ([2.57])

AC_DEFUN([CL_IOCTL],
[
  AC_REQUIRE([CL_TERM])
  AC_CHECK_FUNCS([ioctl])
  if test $ac_cv_func_ioctl = yes; then
    ioctl_decl='
      #include <stdlib.h>
      #ifdef HAVE_UNISTD_H
       #include <sys/types.h>
       #include <unistd.h>
      #endif
      #ifdef HAVE_TERMIOS_H
       #include <termios.h>
      #endif
      '
    ioctl_prog='int x = FIONREAD;'
    CL_COMPILE_CHECK([FIONREAD], [cl_cv_decl_FIONREAD_1],
      [$ioctl_decl], [$ioctl_prog], [ioctl_ok=1])
    if test -z "$ioctl_ok"; then
      CL_COMPILE_CHECK([FIONREAD in sys/filio.h], [cl_cv_decl_FIONREAD_1_sys_filio_h],
        [$ioctl_decl
         #include <sys/filio.h>
        ],
        [$ioctl_prog],
        [AC_DEFINE([NEED_SYS_FILIO_H],,[need <sys/filio.h> for using ioctl() FIONREAD])
         ioctl_ok=1
        ])
    fi
    if test -z "$ioctl_ok"; then
      CL_COMPILE_CHECK([FIONREAD in sys/ioctl.h], [cl_cv_decl_FIONREAD_1_sys_ioctl_h],
        [$ioctl_decl
         #include <sys/ioctl.h>
        ],
        [$ioctl_prog],
        [AC_DEFINE(NEED_SYS_IOCTL_H,,[need <sys/ioctl.h> for using ioctl() FIONREAD])
         ioctl_ok=1
        ])
    fi
    if test -n "$ioctl_ok"; then
      AC_DEFINE([HAVE_FIONREAD],,[have the FIONREAD ioctl()])
      # Now check whether FIONREAD reliably checks for the EOF of a regular file.
      # The number of available characters returned by ioctl(fd,FIONREAD,...) should
      # be > 0 for a non-empty regular file at least. On Solaris 2, it is 0.
      AC_CACHE_CHECK([for reliable FIONREAD], [cl_cv_decl_FIONREAD_reliable],
        [AC_RUN_IFELSE(
           [AC_LANG_SOURCE([[
              /* Declare ioctl(). */
              $ioctl_decl
              #ifdef NEED_SYS_FILIO_H
               #include <sys/filio.h>
              #endif
              #ifdef NEED_SYS_IOCTL_H
               #include <sys/ioctl.h>
              #endif
              /* Declare open(). */
              #include <fcntl.h>
              int main ()
              {
                int fd = open("conftest.c",O_RDONLY,0644);
                unsigned long bytes_ready;
                /* Clear bytes_ready before use. Some kernels (such as Linux-2.4.18 on ia64)
                   apparently expect an 'int *', not a 'long *', as argument of this ioctl,
                   and thus fill only part of the bytes_ready variable. Fortunately,
                   endianness is not a problem here, because we only check whether
                   bytes_ready is == 0 or != 0. */
                bytes_ready = 0;
                exit(!((fd >= 0) && (ioctl(fd,FIONREAD,&bytes_ready) >= 0) && (bytes_ready > 0)));
              }
           ]])],
           [cl_cv_decl_FIONREAD_reliable=yes], [cl_cv_decl_FIONREAD_reliable=no],
           [dnl When cross-compiling, don't assume anything.
            cl_cv_decl_FIONREAD_reliable="guessing no"
           ])
        ])
      case "$cl_cv_decl_FIONREAD_reliable" in
        *yes) AC_DEFINE([HAVE_RELIABLE_FIONREAD],,[have the FIONREAD ioctl() and it works reliably on files]) ;;
        *no) ;;
      esac
    fi
  fi
])
