﻿
# ../tutorial_atl.rpyc:187
translate piglatin tutorial_positions_a09a3fd1:

    # e "In this tutorial, I'll teach you how Ren'Py positions things on the screen. But before that, let's learn a little bit about how Python handles numbers."
    e "Niay histay utorialtay, Iay'llay eachtay ouyay owhay Enray'Ypay ositionspay hingstay onay hetay creensay. Utbay eforebay hattay, etlay'say earnlay aay ittlelay itbay aboutay owhay Ythonpay andleshay umbersnay."

# ../tutorial_atl.rpyc:189
translate piglatin tutorial_positions_ba39aabc:

    # e "There are two main kinds of numbers in Python: integers and floating point numbers. An integer consists entirely of digits, while a floating point number has a decimal point."
    e "Heretay areay wotay ainmay indskay ofay umbersnay inay Ythonpay: integersay anday oatingflay ointpay umbersnay. Naay integeray onsistscay entirelyay ofay igitsday, hileway aay oatingflay ointpay umbernay ashay aay ecimalday ointpay."

# ../tutorial_atl.rpyc:191
translate piglatin tutorial_positions_a60b775d:

    # e "For example, 100 is an integer, while 0.5 is a floating point number, or float for short. In this system, there are two zeros: 0 is an integer, and 0.0 is a float."
    e "Orfay exampleay, 001ay isay anay integeray, hileway 0ay.5ay isay aay oatingflay ointpay umbernay, oray oatflay orfay ortshay. Niay histay ystemsay, heretay areay wotay eroszay: 0ay isay anay integeray, anday 0ay.0ay isay aay oatflay."

# ../tutorial_atl.rpyc:193
translate piglatin tutorial_positions_7f1a560c:

    # e "Ren'Py uses integers to represent absolute coordinates, and floats to represent fractions of an area with known size."
    e "Enray'Ypay usesay integersay otay epresentray absoluteay oordinatescay, anday oatsflay otay epresentray actionsfray ofay anay areaay ithway nownkay izesay."

# ../tutorial_atl.rpyc:195
translate piglatin tutorial_positions_8e7d3e52:

    # e "When we're positioning something, the area is usually the entire screen."
    e "Henway eway'eray ositioningpay omethingsay, hetay areaay isay usuallyay hetay entireay creensay."

# ../tutorial_atl.rpyc:197
translate piglatin tutorial_positions_fdcf9d8b:

    # e "Let me get out of the way, and I'll show you where some positions are."
    e "Etlay emay etgay outay ofay hetay ayway, anday Iay'llay owshay ouyay hereway omesay ositionspay areay."

# ../tutorial_atl.rpyc:211
translate piglatin tutorial_positions_76d7a5bf:

    # e "The origin is the upper-left corner of the screen. That's where the x position (xpos) and the y position (ypos) are both zero."
    e "Hetay originay isay hetay upperay-eftlay ornercay ofay hetay creensay. Hattay'say hereway hetay xay ositionpay (posxay) anday hetay yay ositionpay (posyay) areay othbay erozay."

# ../tutorial_atl.rpyc:217
translate piglatin tutorial_positions_be14c7c3:

    # e "When we increase xpos, we move to the right. So here's an xpos of .5, meaning half the width across the screen."
    e "Henway eway increaseay posxay, eway ovemay otay hetay ightray. Osay erehay'say anay posxay ofay .5ay, eaningmay alfhay hetay idthway acrossay hetay creensay."

# ../tutorial_atl.rpyc:222
translate piglatin tutorial_positions_9b91be6c:

    # e "Increasing xpos to 1.0 moves us to the right-hand border of the screen."
    e "Ncreasingiay posxay otay 1ay.0ay ovesmay usay otay hetay ightray-andhay orderbay ofay hetay creensay."

# ../tutorial_atl.rpyc:228
translate piglatin tutorial_positions_80be064f:

    # e "We can also use an absolute xpos, which is given in an absolute number of pixels from the left side of the screen. For example, since this window is 800 pixels across, using an xpos of 400 will return the target to the center of the top row."
    e "Eway ancay alsoay useay anay absoluteay posxay, hichway isay ivengay inay anay absoluteay umbernay ofay ixelspay omfray hetay eftlay idesay ofay hetay creensay. Orfay exampleay, incesay histay indowway isay 008ay ixelspay acrossay, usingay anay posxay ofay 004ay illway eturnray hetay argettay otay hetay entercay ofay hetay optay owray."

# ../tutorial_atl.rpyc:230
translate piglatin tutorial_positions_c4d18c0a:

    # e "The y-axis position, or ypos works the same way. Right now, we have a ypos of 0.0."
    e "Hetay yay-axisay ositionpay, oray posyay orksway hetay amesay ayway. Ightray ownay, eway avehay aay posyay ofay 0ay.0ay."

# ../tutorial_atl.rpyc:236
translate piglatin tutorial_positions_16933a61:

    # e "Here's a ypos of 0.5."
    e "Erehay'say aay posyay ofay 0ay.5ay."

# ../tutorial_atl.rpyc:241
translate piglatin tutorial_positions_6eb36777:

    # e "A ypos of 1.0 specifies a position at the bottom of the screen. If you look carefully, you can see the position indicator spinning below the text window."
    e "Aay posyay ofay 1ay.0ay pecifiessay aay ositionpay atay hetay ottombay ofay hetay creensay. Fiay ouyay ooklay arefullycay, ouyay ancay eesay hetay ositionpay indicatoray pinningsay elowbay hetay exttay indowway."

# ../tutorial_atl.rpyc:243
translate piglatin tutorial_positions_a423050f:

    # e "Like xpos, ypos can also be an integer. In this case, ypos would give the total number of pixels from the top of the screen."
    e "Ikelay posxay, posyay ancay alsoay ebay anay integeray. Niay histay asecay, posyay ouldway ivegay hetay otaltay umbernay ofay ixelspay omfray hetay optay ofay hetay creensay."

# ../tutorial_atl.rpyc:249
translate piglatin tutorial_positions_bc7a809a:

    # e "Can you guess where this position is, relative to the screen?" nointeract
    e "Ancay ouyay uessgay hereway histay ositionpay isay, elativeray otay hetay creensay?" nointeract

# ../tutorial_atl.rpyc:255
translate piglatin tutorial_positions_6f926e18:

    # e "Sorry, that's wrong. The xpos is .75, and the ypos is .25."
    e "Orrysay, hattay'say rongway. Hetay posxay isay .57ay, anday hetay posyay isay .52ay."

# ../tutorial_atl.rpyc:257
translate piglatin tutorial_positions_5d5feb98:

    # e "In other words, it's 75%% of the way from the left side, and 25%% of the way from the top."
    e "Niay otheray ordsway, itay'say 57ay%% ofay hetay ayway omfray hetay eftlay idesay, anday 52ay%% ofay hetay ayway omfray hetay optay."

# ../tutorial_atl.rpyc:261
translate piglatin tutorial_positions_77b45218:

    # e "Good job! You got that position right."
    e "Oodgay objay! Ouyay otgay hattay ositionpay ightray."

# ../tutorial_atl.rpyc:265
translate piglatin tutorial_positions_6f926e18_1:

    # e "Sorry, that's wrong. The xpos is .75, and the ypos is .25."
    e "Orrysay, hattay'say rongway. Hetay posxay isay .57ay, anday hetay posyay isay .52ay."

# ../tutorial_atl.rpyc:267
translate piglatin tutorial_positions_5d5feb98_1:

    # e "In other words, it's 75%% of the way from the left side, and 25%% of the way from the top."
    e "Niay otheray ordsway, itay'say 57ay%% ofay hetay ayway omfray hetay eftlay idesay, anday 52ay%% ofay hetay ayway omfray hetay optay."

# ../tutorial_atl.rpyc:281
translate piglatin tutorial_positions_e4380a83:

    # e "The second position we care about is the anchor. The anchor is a spot on the thing being positioned."
    e "Hetay econdsay ositionpay eway arecay aboutay isay hetay anchoray. Hetay anchoray isay aay potsay onay hetay hingtay eingbay ositionedpay."

# ../tutorial_atl.rpyc:283
translate piglatin tutorial_positions_d1db1246:

    # e "For example, here we have an xanchor of 0.0 and a yanchor of 0.0. It's in the upper-left corner of the logo image."
    e "Orfay exampleay, erehay eway avehay anay anchorxay ofay 0ay.0ay anday aay anchoryay ofay 0ay.0ay. Tiay'say inay hetay upperay-eftlay ornercay ofay hetay ogolay imageay."

# ../tutorial_atl.rpyc:288
translate piglatin tutorial_positions_6056873f:

    # e "When we increase the xanchor to 1.0, the anchor moves to the right corner of the image."
    e "Henway eway increaseay hetay anchorxay otay 1ay.0ay, hetay anchoray ovesmay otay hetay ightray ornercay ofay hetay imageay."

# ../tutorial_atl.rpyc:293
translate piglatin tutorial_positions_7cdb8dcc:

    # e "Similarly, when both xanchor and yanchor are 1.0, the anchor is the bottom-right corner."
    e "Imilarlysay, henway othbay anchorxay anday anchoryay areay 1ay.0ay, hetay anchoray isay hetay ottombay-ightray ornercay."

# ../tutorial_atl.rpyc:301
translate piglatin tutorial_positions_03a07da8:

    # e "To place an image on the screen, we need both the position and the anchor."
    e "Otay aceplay anay imageay onay hetay creensay, eway eednay othbay hetay ositionpay anday hetay anchoray."

# ../tutorial_atl.rpyc:309
translate piglatin tutorial_positions_8945054f:

    # e "We then line them up, so that both the position and anchor are at the same point on the screen."
    e "Eway hentay inelay hemtay upay, osay hattay othbay hetay ositionpay anday anchoray areay atay hetay amesay ointpay onay hetay creensay."

# ../tutorial_atl.rpyc:319
translate piglatin tutorial_positions_2b184a93:

    # e "When we place both in the upper-left corner, the image moves to the upper-left corner of the screen."
    e "Henway eway aceplay othbay inay hetay upperay-eftlay ornercay, hetay imageay ovesmay otay hetay upperay-eftlay ornercay ofay hetay creensay."

# ../tutorial_atl.rpyc:328
translate piglatin tutorial_positions_5aac4f3f:

    # e "With the right combination of position and anchor, any place on the screen can be specified, without even knowing the size of the image."
    e "Ithway hetay ightray ombinationcay ofay ositionpay anday anchoray, anyay aceplay onay hetay creensay ancay ebay pecifiedsay, ithoutway evenay nowingkay hetay izesay ofay hetay imageay."

# ../tutorial_atl.rpyc:340
translate piglatin tutorial_positions_3b59b797:

    # e "It's often useful to set xpos and xanchor to the same value. We call that xalign, and it gives a fractional position on the screen."
    e "Tiay'say oftenay usefulay otay etsay posxay anday anchorxay otay hetay amesay aluevay. Eway allcay hattay alignxay, anday itay ivesgay aay actionalfray ositionpay onay hetay creensay."

# ../tutorial_atl.rpyc:345
translate piglatin tutorial_positions_b8ebf9fe:

    # e "For example, when we set xalign to 0.0, things are aligned to the left side of the screen."
    e "Orfay exampleay, henway eway etsay alignxay otay 0ay.0ay, hingstay areay aligneday otay hetay eftlay idesay ofay hetay creensay."

# ../tutorial_atl.rpyc:350
translate piglatin tutorial_positions_8ce35d52:

    # e "When we set it to 1.0, then we're aligned to the right side of the screen."
    e "Henway eway etsay itay otay 1ay.0ay, hentay eway'eray aligneday otay hetay ightray idesay ofay hetay creensay."

# ../tutorial_atl.rpyc:355
translate piglatin tutorial_positions_6745825f:

    # e "And when we set it to 0.5, we're back to the center of the screen."
    e "Ndaay henway eway etsay itay otay 0ay.5ay, eway'eray ackbay otay hetay entercay ofay hetay creensay."

# ../tutorial_atl.rpyc:357
translate piglatin tutorial_positions_64428a07:

    # e "Setting yalign is similar, except along the y-axis."
    e "Ettingsay alignyay isay imilarsay, exceptay alongay hetay yay-axisay."

# ../tutorial_atl.rpyc:359
translate piglatin tutorial_positions_cfb77d42:

    # e "Remember that xalign is just setting xpos and xanchor to the same value, and yalign is just setting ypos and yanchor to the same value."
    e "Ememberray hattay alignxay isay ustjay ettingsay posxay anday anchorxay otay hetay amesay aluevay, anday alignyay isay ustjay ettingsay posyay anday anchoryay otay hetay amesay aluevay."

# ../tutorial_atl.rpyc:366
translate piglatin tutorial_positions_0f4ca2b6:

    # e "Once you understand positions, you can use transformations to move things around the Ren'Py screen."
    e "Nceoay ouyay understanday ositionspay, ouyay ancay useay ansformationstray otay ovemay hingstay arounday hetay Enray'Ypay creensay."

# ../tutorial_atl.rpyc:373
translate piglatin tutorial_atl_a1cc1bff:

    # e "While showing static images is often enough for most games, occasionally we'll want to change images, or move them around the screen."
    e "Hileway owingshay aticstay imagesay isay oftenay enoughay orfay ostmay amesgay, occasionallyay eway'llay antway otay angechay imagesay, oray ovemay hemtay arounday hetay creensay."

# ../tutorial_atl.rpyc:375
translate piglatin tutorial_atl_81dbb8f2:

    # e "We call this a Transform, and it's what ATL, Ren'Py's Animation and Transformation Language, is for."
    e "Eway allcay histay aay Ransformtay, anday itay'say hatway Tlaay, Enray'Ypay'say Nimationaay anday Ransformationtay Anguagelay, isay orfay."

# ../tutorial_atl.rpyc:383
translate piglatin tutorial_atl_65badef3:

    # e "But first, let's have... a Gratuitous Rock Concert!"
    e "Utbay irstfay, etlay'say avehay... aay Ratuitousgay Ockray Oncertcay!"

# ../tutorial_atl.rpyc:391
translate piglatin tutorial_atl_3ccfe2ac:

    # e "That was a lot of work, and before you can do that, we'll need to start with the basics of using ATL."
    e "Hattay asway aay otlay ofay orkway, anday eforebay ouyay ancay oday hattay, eway'llay eednay otay artstay ithway hetay asicsbay ofay usingay Tlaay."

# ../tutorial_atl.rpyc:393
translate piglatin tutorial_atl_1f22f875:

    # e "There are currently three places where ATL can be used in Ren'Py."
    e "Heretay areay urrentlycay hreetay acesplay hereway Tlaay ancay ebay useday inay Enray'Ypay."

# ../tutorial_atl.rpyc:397
translate piglatin tutorial_atl_fd036bdf:

    # e "The first place ATL can be used is as part of an image statement. Instead of a displayable, an image may be defined as a block of ATL code."
    e "Hetay irstfay aceplay Tlaay ancay ebay useday isay asay artpay ofay anay imageay atementstay. Nsteadiay ofay aay isplayableday, anay imageay aymay ebay efinedday asay aay ockblay ofay Tlaay odecay."

# ../tutorial_atl.rpyc:399
translate piglatin tutorial_atl_7cad2ab9:

    # e "When used in this way, we have to be sure that ATL includes one or more displayables to actually show."
    e "Henway useday inay histay ayway, eway avehay otay ebay uresay hattay Tlaay includesay oneay oray oremay isplayablesday otay actuallyay owshay."

# ../tutorial_atl.rpyc:403
translate piglatin tutorial_atl_c78b2a1e:

    # e "The second way is through the use of the transform statement. This assigns the ATL block to a python variable, allowing it to be used in at clauses and inside other transforms."
    e "Hetay econdsay ayway isay hroughtay hetay useay ofay hetay ansformtray atementstay. Histay assignsay hetay Tlaay ockblay otay aay ythonpay ariablevay, allowingay itay otay ebay useday inay atay ausesclay anday insideay otheray ansformstray."

# ../tutorial_atl.rpyc:407
translate piglatin tutorial_atl_da7a7759:

    # e "Finally, an ATL block can be used as part of a show statement, instead of the at clause."
    e "Inallyfay, anay Tlaay ockblay ancay ebay useday asay artpay ofay aay owshay atementstay, insteaday ofay hetay atay auseclay."

# ../tutorial_atl.rpyc:411
translate piglatin tutorial_atl_c21bc1d1:

    # e "The key to ATL is what we call composeability. ATL is made up of relatively simple commands, which can be combined together to create complicated transforms."
    e "Hetay eykay otay Tlaay isay hatway eway allcay omposeabilitycay. Tlaay isay ademay upay ofay elativelyray implesay ommandscay, hichway ancay ebay ombinedcay ogethertay otay reatecay omplicatedcay ansformstray."

# ../tutorial_atl.rpyc:413
translate piglatin tutorial_atl_ed82983f:

    # e "Before I explain how ATL works, let me explain what animation and transformation are."
    e "Eforebay Iay explainay owhay Tlaay orksway, etlay emay explainay hatway animationay anday ansformationtray areay."

# ../tutorial_atl.rpyc:418
translate piglatin tutorial_atl_2807adff:

    # e "Animation is when the displayable being shown changes. For example, right now I am changing my expression."
    e "Nimationaay isay henway hetay isplayableday eingbay ownshay angeschay. Orfay exampleay, ightray ownay Iay amay angingchay ymay expressionay."

# ../tutorial_atl.rpyc:445
translate piglatin tutorial_atl_3eec202b:

    # e "Transformation involves moving or distorting an image. This includes placing it on the screen, zooming it in and out, rotating it, and changing its opacity."
    e "Ransformationtay involvesay ovingmay oray istortingday anay imageay. Histay includesay acingplay itay onay hetay creensay, oomingzay itay inay anday outay, otatingray itay, anday angingchay itsay opacityay."

# ../tutorial_atl.rpyc:453
translate piglatin tutorial_atl_fbc9bf83:

    # e "To introduce ATL, let's start by looking at at a simple animation. Here's one that consists of five lines of ATL code, contained within an image statement."
    e "Otay introduceay Tlaay, etlay'say artstay ybay ookinglay atay atay aay implesay animationay. Erehay'say oneay hattay onsistscay ofay ivefay ineslay ofay Tlaay odecay, ontainedcay ithinway anay imageay atementstay."

# ../tutorial_atl.rpyc:455
translate piglatin tutorial_atl_12c839ee:

    # e "In ATL, to change a displayable, simply mention it on a line of ATL code. Here, we're switching back and forth between two images."
    e "Niay Tlaay, otay angechay aay isplayableday, implysay entionmay itay onay aay inelay ofay Tlaay odecay. Erehay, eway'eray witchingsay ackbay anday orthfay etweenbay wotay imagesay."

# ../tutorial_atl.rpyc:457
translate piglatin tutorial_atl_c671ed7d:

    # e "Since we're defining an image, the first line of ATL has to name a displayable. Otherwise, there would be nothing to show."
    e "Incesay eway'eray efiningday anay imageay, hetay irstfay inelay ofay Tlaay ashay otay amenay aay isplayableday. Therwiseoay, heretay ouldway ebay othingnay otay owshay."

# ../tutorial_atl.rpyc:459
translate piglatin tutorial_atl_99386181:

    # e "The second and fourth lines are pause statements, which cause ATL to wait half of a second each before continuing. That's how we give the delay between images."
    e "Hetay econdsay anday ourthfay ineslay areay ausepay atementsstay, hichway ausecay Tlaay otay aitway alfhay ofay aay econdsay eachay eforebay ontinuingcay. Hattay'say owhay eway ivegay hetay elayday etweenbay imagesay."

# ../tutorial_atl.rpyc:461
translate piglatin tutorial_atl_60f2a5e8:

    # e "The final line is a repeat statement. This causes the current block of ATL to be restarted. You can only have one repeat statement per block."
    e "Hetay inalfay inelay isay aay epeatray atementstay. Histay ausescay hetay urrentcay ockblay ofay Tlaay otay ebay estartedray. Ouyay ancay onlyay avehay oneay epeatray atementstay erpay ockblay."

# ../tutorial_atl.rpyc:466
translate piglatin tutorial_atl_146cf4c4:

    # e "If we were to write repeat 2 instead, the animation would loop twice, then stop."
    e "Fiay eway ereway otay riteway epeatray 2ay insteaday, hetay animationay ouldway ooplay wicetay, hentay opstay."

# ../tutorial_atl.rpyc:471
translate piglatin tutorial_atl_d90b1838:

    # e "Omitting the repeat statement means that the animation stops once we reach the end of the block of ATL code."
    e "Mittingoay hetay epeatray atementstay eansmay hattay hetay animationay opsstay onceay eway eachray hetay enday ofay hetay ockblay ofay Tlaay odecay."

# ../tutorial_atl.rpyc:476
translate piglatin tutorial_atl_e5872360:

    # e "By default, displayables are replaced instantaneously. We can also use a with clause to give a transition between displayables."
    e "Ybay efaultday, isplayablesday areay eplacedray instantaneouslyay. Eway ancay alsoay useay aay ithway auseclay otay ivegay aay ansitiontray etweenbay isplayablesday."

# ../tutorial_atl.rpyc:483
translate piglatin tutorial_atl_a7f8ed01:

    # e "Now, let's move on to see how we can use ATL to transform an image. We'll start off by seeing what we can do to position images on the screen."
    e "Ownay, etlay'say ovemay onay otay eesay owhay eway ancay useay Tlaay otay ansformtray anay imageay. Eway'llay artstay offay ybay eeingsay hatway eway ancay oday otay ositionpay imagesay onay hetay creensay."

# ../tutorial_atl.rpyc:492
translate piglatin tutorial_atl_24501213:

    # e "Perhaps the simplest thing we can do is to position the images on the screen. This can be done by simply giving the names of the transform properties, each followed by the value."
    e "Erhapspay hetay implestsay hingtay eway ancay oday isay otay ositionpay hetay imagesay onay hetay creensay. Histay ancay ebay oneday ybay implysay ivinggay hetay amesnay ofay hetay ansformtray ropertiespay, eachay ollowedfay ybay hetay aluevay."

# ../tutorial_atl.rpyc:497
translate piglatin tutorial_atl_43516492:

    # e "With a few more statements, we can move things around on the screen."
    e "Ithway aay ewfay oremay atementsstay, eway ancay ovemay hingstay arounday onay hetay creensay."

# ../tutorial_atl.rpyc:499
translate piglatin tutorial_atl_8b053b5a:

    # e "This code starts the image off at the top-right of the screen, and waits a second."
    e "Histay odecay artsstay hetay imageay offay atay hetay optay-ightray ofay hetay creensay, anday aitsway aay econdsay."

# ../tutorial_atl.rpyc:501
translate piglatin tutorial_atl_d7fc5372:

    # e "It then moves it to the left side, waits another second, and repeats."
    e "Tiay hentay ovesmay itay otay hetay eftlay idesay, aitsway anotheray econdsay, anday epeatsray."

# ../tutorial_atl.rpyc:503
translate piglatin tutorial_atl_7650ec09:

    # e "The pause and repeat statements are the same statements we used in our animations. They work throughout ATL code."
    e "Hetay ausepay anday epeatray atementsstay areay hetay amesay atementsstay eway useday inay ouray animationsay. Heytay orkway hroughouttay Tlaay odecay."

# ../tutorial_atl.rpyc:508
translate piglatin tutorial_atl_d3416d4f:

    # e "Having the image jump around on the screen isn't all that useful. That's why ATL has the interpolation statement."
    e "Avinghay hetay imageay umpjay arounday onay hetay creensay isnay'tay allay hattay usefulay. Hattay'say hyway Tlaay ashay hetay interpolationay atementstay."

# ../tutorial_atl.rpyc:510
translate piglatin tutorial_atl_4e7512ec:

    # e "The interpolation statement allows you to smoothly vary the value of a transform property, from an old to a new value."
    e "Hetay interpolationay atementstay allowsay ouyay otay moothlysay aryvay hetay aluevay ofay aay ansformtray ropertypay, omfray anay olday otay aay ewnay aluevay."

# ../tutorial_atl.rpyc:512
translate piglatin tutorial_atl_685eeeaa:

    # e "Here, we have an interpolation statement on the second ATL line. It starts off with the name of a time function, in this case linear."
    e "Erehay, eway avehay anay interpolationay atementstay onay hetay econdsay Tlaay inelay. Tiay artsstay offay ithway hetay amenay ofay aay imetay unctionfay, inay histay asecay inearlay."

# ../tutorial_atl.rpyc:514
translate piglatin tutorial_atl_c5cb49de:

    # e "That's followed by an amount of time, in this case three seconds. It ends with a list of properties, each followed by its new value."
    e "Hattay'say ollowedfay ybay anay amountay ofay imetay, inay histay asecay hreetay econdssay. Tiay endsay ithway aay istlay ofay ropertiespay, eachay ollowedfay ybay itsay ewnay aluevay."

# ../tutorial_atl.rpyc:516
translate piglatin tutorial_atl_72d47fb6:

    # e "The old value is the value of the transform property at the start of the statement. By interpolating the property over time, we can change things on the screen."
    e "Hetay olday aluevay isay hetay aluevay ofay hetay ansformtray ropertypay atay hetay artstay ofay hetay atementstay. Ybay interpolatingay hetay ropertypay overay imetay, eway ancay angechay hingstay onay hetay creensay."

# ../tutorial_atl.rpyc:526
translate piglatin tutorial_atl_2958f397:

    # e "ATL supports more complicated move types, like circle and spline motion. But I won't be showing those here."
    e "Tlaay upportssay oremay omplicatedcay ovemay ypestay, ikelay irclecay anday plinesay otionmay. Utbay Iay onway'tay ebay owingshay hosetay erehay."

# ../tutorial_atl.rpyc:528
translate piglatin tutorial_atl_4a02c8d8:

    # e "Next, let's take a look at some of the transform properties that we can change using ATL."
    e "Extnay, etlay'say aketay aay ooklay atay omesay ofay hetay ansformtray ropertiespay hattay eway ancay angechay usingay Tlaay."

# ../tutorial_atl.rpyc:543
translate piglatin tutorial_atl_821fcb91:

    # e "We've already seen the position properties. Along with xalign and yalign, we support the xpos, ypos, xanchor, and yanchor properties."
    e "Eway'evay alreadyay eensay hetay ositionpay ropertiespay. Longaay ithway alignxay anday alignyay, eway upportsay hetay posxay, posyay, anchorxay, anday anchoryay ropertiespay."

# ../tutorial_atl.rpyc:558
translate piglatin tutorial_atl_cca5082b:

    # e "We can perform a pan by using xpos and ypos to position images off of the screen."
    e "Eway ancay erformpay aay anpay ybay usingay posxay anday posyay otay ositionpay imagesay offay ofay hetay creensay."

# ../tutorial_atl.rpyc:560
translate piglatin tutorial_atl_0394dd50:

    # e "This usually means giving them negative positions."
    e "Histay usuallyay eansmay ivinggay hemtay egativenay ositionspay."

# ../tutorial_atl.rpyc:577
translate piglatin tutorial_atl_2624662e:

    # e "The zoom property lets us scale the displayable by a factor, making it bigger and smaller. For best results, zoom should always be greater than 0.5."
    e "Hetay oomzay ropertypay etslay usay calesay hetay isplayableday ybay aay actorfay, akingmay itay iggerbay anday mallersay. Orfay estbay esultsray, oomzay ouldshay alwaysay ebay eatergray hantay 0ay.5ay."

# ../tutorial_atl.rpyc:591
translate piglatin tutorial_atl_b6527546:

    # e "The xzoom and yzoom properties allow the displayable to be scaled in the X and Y directions independently."
    e "Hetay zoomxay anday zoomyay ropertiespay alloway hetay isplayableday otay ebay caledsay inay hetay Xay anday Yay irectionsday independentlyay."

# ../tutorial_atl.rpyc:602
translate piglatin tutorial_atl_9fe238de:

    # e "The size property can be used to set a size, in pixels, that the displayable is scaled to."
    e "Hetay izesay ropertypay ancay ebay useday otay etsay aay izesay, inay ixelspay, hattay hetay isplayableday isay caledsay otay."

# ../tutorial_atl.rpyc:617
translate piglatin tutorial_atl_6b982a23:

    # e "The alpha property allows us to vary the opacity of a displayable. This can make it appear and disappear."
    e "Hetay alphaay ropertypay allowsay usay otay aryvay hetay opacityay ofay aay isplayableday. Histay ancay akemay itay appearay anday isappearday."

# ../tutorial_atl.rpyc:631
translate piglatin tutorial_atl_60d6d9f3:

    # e "The rotate property lets us rotate a displayable."
    e "Hetay otateray ropertypay etslay usay otateray aay isplayableday."

# ../tutorial_atl.rpyc:633
translate piglatin tutorial_atl_898a138a:

    # e "Since rotation can change the size, usually you'll want to set xanchor and yanchor to 0.5 when positioning a rotated displayable."
    e "Incesay otationray ancay angechay hetay izesay, usuallyay ouyay'llay antway otay etsay anchorxay anday anchoryay otay 0ay.5ay henway ositioningpay aay otatedray isplayableday."

# ../tutorial_atl.rpyc:644
translate piglatin tutorial_atl_207b7fc8:

    # e "The crop property crops a rectangle out of a displayable, showing only part of it."
    e "Hetay ropcay ropertypay ropscay aay ectangleray outay ofay aay isplayableday, owingshay onlyay artpay ofay itay."

# ../tutorial_atl.rpyc:658
translate piglatin tutorial_atl_ebb84988:

    # e "When used together, they can be used to focus in on specific parts of an image."
    e "Henway useday ogethertay, heytay ancay ebay useday otay ocusfay inay onay pecificsay artspay ofay anay imageay."

# ../tutorial_atl.rpyc:664
translate piglatin tutorial_atl_d08fe8d9:

    # e "Apart from displayables, pause, interpolation, and repeat, there are a few other statements we can use as part of ATL."
    e "Partaay omfray isplayablesday, ausepay, interpolationay, anday epeatray, heretay areay aay ewfay otheray atementsstay eway ancay useay asay artpay ofay Tlaay."

# ../tutorial_atl.rpyc:678
translate piglatin tutorial_atl_db6302bd:

    # e "When we create an ATL transform using the transform statement, we can use that transform as an ATL statement."
    e "Henway eway reatecay anay Tlaay ansformtray usingay hetay ansformtray atementstay, eway ancay useay hattay ansformtray asay anay Tlaay atementstay."

# ../tutorial_atl.rpyc:680
translate piglatin tutorial_atl_785911cf:

    # e "Since the default positions are also transforms, this means that we can use left, right, and center inside of an ATL block."
    e "Incesay hetay efaultday ositionspay areay alsoay ansformstray, histay eansmay hattay eway ancay useay eftlay, ightray, anday entercay insideay ofay anay Tlaay ockblay."

# ../tutorial_atl.rpyc:698
translate piglatin tutorial_atl_331126c1:

    # e "Here, we have two new statements. The block statement allows you to include a block of ATL code. Since the repeat statement applies to blocks, this lets you repeat only part of an ATL transform."
    e "Erehay, eway avehay wotay ewnay atementsstay. Hetay ockblay atementstay allowsay ouyay otay includeay aay ockblay ofay Tlaay odecay. Incesay hetay epeatray atementstay appliesay otay ocksblay, histay etslay ouyay epeatray onlyay artpay ofay anay Tlaay ansformtray."

# ../tutorial_atl.rpyc:700
translate piglatin tutorial_atl_24f67b67:

    # e "We also have the time statement, which runs after the given number of seconds have elapsed from the start of the block. It will run even if another statement is running, stopping the other statement."
    e "Eway alsoay avehay hetay imetay atementstay, hichway unsray afteray hetay ivengay umbernay ofay econdssay avehay elapseday omfray hetay artstay ofay hetay ockblay. Tiay illway unray evenay ifay anotheray atementstay isay unningray, oppingstay hetay otheray atementstay."

# ../tutorial_atl.rpyc:702
translate piglatin tutorial_atl_30dc0008:

    # e "So this code will bounce the image back and forth for eleven and a half seconds, and then move back to the right side of the screen."
    e "Osay histay odecay illway ouncebay hetay imageay ackbay anday orthfay orfay elevenay anday aay alfhay econdssay, anday hentay ovemay ackbay otay hetay ightray idesay ofay hetay creensay."

# ../tutorial_atl.rpyc:718
translate piglatin tutorial_atl_f903bc3b:

    # e "The parallel statement lets us run two blocks of ATL code at the same time."
    e "Hetay arallelpay atementstay etslay usay unray wotay ocksblay ofay Tlaay odecay atay hetay amesay imetay."

# ../tutorial_atl.rpyc:720
translate piglatin tutorial_atl_5d0f8f9d:

    # e "Here, the top block move the image in the horizontal direction, and the bottom block moves it in the vertical direction. Since they're moving at different speeds, it looks like the image is bouncing on the screen."
    e "Erehay, hetay optay ockblay ovemay hetay imageay inay hetay orizontalhay irectionday, anday hetay ottombay ockblay ovesmay itay inay hetay erticalvay irectionday. Incesay heytay'eray ovingmay atay ifferentday peedssay, itay ookslay ikelay hetay imageay isay ouncingbay onay hetay creensay."

# ../tutorial_atl.rpyc:737
translate piglatin tutorial_atl_28a7d27e:

    # e "Finally, the choice statement makes Ren'Py randomly pick a block of ATL code. This allows you to add some variation as to what Ren'Py shows."
    e "Inallyfay, hetay oicechay atementstay akesmay Enray'Ypay andomlyray ickpay aay ockblay ofay Tlaay odecay. Histay allowsay ouyay otay adday omesay ariationvay asay otay hatway Enray'Ypay owsshay."

# ../tutorial_atl.rpyc:743
translate piglatin tutorial_atl_5fc8c0df:

    # e "This tutorial game has only scratched the surface of what you can do with ATL. For example, we haven't even covered the on and event statements. For more information, you might want to check out the ATL chapter in the reference manual."
    e "Histay utorialtay amegay ashay onlyay cratchedsay hetay urfacesay ofay hatway ouyay ancay oday ithway Tlaay. Orfay exampleay, eway avenhay'tay evenay overedcay hetay onay anday eventay atementsstay. Orfay oremay informationay, ouyay ightmay antway otay eckchay outay hetay Tlaay apterchay inay hetay eferenceray anualmay."

# ../tutorial_atl.rpyc:747
translate piglatin tutorial_atl_1358c6b4:

    # e "But for now, just remember that when it comes to animating and transforming, ATL is the hot new thing."
    e "Utbay orfay ownay, ustjay ememberray hattay henway itay omescay otay animatingay anday ansformingtray, Tlaay isay hetay othay ewnay hingtay."

translate piglatin strings:

    # tutorial_atl.rpy:249
    old "xpos 1.0 ypos .5"
    new "posxay 1ay.0ay posyay .5ay"

    # tutorial_atl.rpy:249
    old "xpos .75 ypos .25"
    new "posxay .57ay posyay .52ay"

    # tutorial_atl.rpy:249
    old "xpos .25 ypos .33"
    new "posxay .52ay posyay .33ay"

